package io.agora.avc.app.address

import androidx.core.view.isVisible
import io.agora.avc.R
import io.agora.avc.databinding.AvcItemMyGroupBinding

class MyGroupViewHolder constructor(val binding: AvcItemMyGroupBinding) :
    androidx.recyclerview.widget.RecyclerView.ViewHolder(binding.root) {

    fun bindTo(data: AddressBookNode?) {
        binding.checkbox.isChecked = data?.isChecked ?: false
        if (data is MyGroupNode) {
            binding.ivPhoto.setImageResource(if (data.groupId == MY_GROUP_DEPT) R.drawable.avc_ic_mine_group else R.drawable.avc_ic_group)
            binding.ivArrow.isVisible = !data.checkable
            binding.tvName.text = data.name
        }
    }

}