package io.agora.avc.app.address

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import io.agora.avc.R
import io.agora.frame.base.BaseRecyclerAdapter

class UserSelectedAdapter : BaseRecyclerAdapter<MemberNode, UserSelectedViewHolder>() {
    override fun convert(
        holder: UserSelectedViewHolder,
        items: MutableList<MemberNode>?,
        position: Int
    ) {
        holder.bindTo(data[position])
        holder.itemView.setOnClickListener {
            userSelectedListener?.onItemClicked(data[position], position)
        }
    }

    override fun bindViewHolder(parent: ViewGroup, viewType: Int): UserSelectedViewHolder {
        return UserSelectedViewHolder(
            DataBindingUtil.inflate(
                LayoutInflater.from(parent.context),
                R.layout.avc_item_user_selected,
                parent,
                false
            )
        )
    }

    private var userSelectedListener: OnUserSelectedListener? = null

    fun setOnUserSelectedListener(listener: OnUserSelectedListener?) {
        this.userSelectedListener = listener
    }

    interface OnUserSelectedListener {
        fun onItemClicked(node: MemberNode, position: Int)
    }
}