package io.agora.avc.app.address

import com.bumptech.glide.Glide
import io.agora.avc.R
import io.agora.avc.databinding.AvcItemUserSelectedBinding

class UserSelectedViewHolder constructor(val binding: AvcItemUserSelectedBinding) :
    androidx.recyclerview.widget.RecyclerView.ViewHolder(binding.root) {

    fun bindTo(data: MemberNode?) {
        Glide.with(binding.root.context)
            .load(data?.avatar)
            .centerCrop()
            .placeholder(R.drawable.avc_ic_head_portrait2)
            .into(binding.ivPhoto)
    }

}