package io.agora.avc.app.attendees

import android.text.SpannableString
import android.text.Spanned
import android.text.style.ForegroundColorSpan
import android.util.TypedValue
import android.view.View
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.bo.LocalUser
import io.agora.avc.bo.valoran.ARoomUser
import io.agora.avc.databinding.AvcItemAttendee2Binding
import io.agora.avc.extensions.isMySelf
import io.agora.avc.listener.AntiShakeClickListener
import io.agora.avc.utils.StringUtils

class Attendees2ViewHolder constructor(val binding: AvcItemAttendee2Binding) :
    RecyclerView.ViewHolder(binding.root), IAttendeesViewHolder {

    private var attendeeClickListener: AttendeesAdapter.IAttendeeClickListener? = null
    private var colorPrimary: Int = 0

    init {
        val typedValue = TypedValue()
        binding.root.context.theme.resolveAttribute(R.attr.colorPrimary, typedValue, true)
        colorPrimary = typedValue.data
    }

    override var user: ARoomUser? = null

    override fun bindUser(user: ARoomUser) {
        bindName(user)
        bindHost(user)
        bindFeature(user)
        bindThirdPartyStatus(user)
        bindThirdPartyDepartment(user)
        bindInviter(user)
        bindAudioStatus(user)
        bindVideoStatus(user)
        bindSpeaking(user)
        bindShareStatus(user)
        setListener(user)
    }

    override fun bindName(user: ARoomUser) {
        if (user.name == null || user.name?.isEmpty() == true) {
            binding.tvUserName.text = StringUtils.getString(R.string.avc_participants_unknown)
        } else if (user.nameStartPos != user.nameEndPos) {
            val spannableString = SpannableString(user.name)
            spannableString.setSpan(
                ForegroundColorSpan(colorPrimary),
                user.nameStartPos,
                user.nameEndPos,
                Spanned.SPAN_INCLUSIVE_INCLUSIVE
            )
            binding.tvUserName.text = spannableString
        } else {
            binding.tvUserName.text = user.name
        }
    }

    override fun bindHost(user: ARoomUser) {
        binding.ivHost.isVisible = user.isHost
    }

    override fun bindFeature(user: ARoomUser) {
        refreshTagLayoutVisible(user)
        binding.tvAudioDump.isVisible = user.isAudioDumping()
    }

    override fun bindThirdPartyStatus(user: ARoomUser) {


    }

    override fun bindThirdPartyDepartment(user: ARoomUser) {

    }

    override fun bindInviter(user: ARoomUser) {

    }

    override fun bindAudioStatus(user: ARoomUser) {
        if (user.isAudioPending) {
            binding.btnAudio.loading = true
        } else {
            binding.btnAudio.loading = false
            binding.btnAudio.mute = !user.audioState
            binding.btnAudio.isMySelf = user.isMySelf()
        }
    }

    override fun bindVideoStatus(user: ARoomUser) {
        if (user.isVideoPending) {
            binding.btnVideo.loading = true
        } else {
            binding.btnVideo.loading = false
            binding.btnVideo.opened = user.videoState
        }
    }

    override fun bindSpeaking(user: ARoomUser) {
        if (user.isAudioPending) {
            binding.btnAudio.loading = true
        } else if (user !is LocalUser) {
            binding.btnAudio.loading = false
            binding.btnAudio.speaking = user.isSpeaking
        } else {
            binding.btnAudio.loading = false
            binding.btnAudio.volume = user.volume
        }
    }

    override fun bindVolume(user: ARoomUser) {
        if (user.isMySelf()) {
            binding.btnAudio.volume = user.volume
        }
    }

    override fun bindShareStatus(user: ARoomUser) {
        refreshTagLayoutVisible(user)
        binding.tvShare.isVisible = user.hasShareStream()
    }

    override fun bindAssistantStatus(user: ARoomUser) {

    }

    private fun refreshTagLayoutVisible(user: ARoomUser) {
        binding.fblTag.isVisible = user.hasShareStream() || user.isAudioDumping()
    }

    private fun setListener(user: ARoomUser) {
        binding.ivHost.setOnClickListener(object : AntiShakeClickListener() {
            override fun onAntiShakeClicked(view: View?) {
                attendeeClickListener?.onAttendeeClicked(user)
            }
        })
        binding.root.setOnClickListener(object : AntiShakeClickListener() {
            override fun onAntiShakeClicked(view: View?) {
                attendeeClickListener?.onAttendeeClicked(user)
            }
        })
    }

    fun setIAttendeeClickListener(listener: AttendeesAdapter.IAttendeeClickListener?) {
        this.attendeeClickListener = listener
    }
}