package io.agora.avc.app.attendees

import android.text.SpannableString
import android.text.Spanned
import android.text.TextUtils
import android.text.style.ForegroundColorSpan
import android.util.TypedValue
import android.view.View
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.bo.valoran.ARoomUser
import io.agora.avc.databinding.AvcItemAttendeeInvitingBinding
import io.agora.avc.listener.AntiShakeClickListener
import io.agora.avc.utils.SizeUtils
import io.agora.avc.utils.StringUtils
import io.agora.avc.widget.drawable.DialingDrawable

class AttendeesInvitingViewHolder constructor(val binding: AvcItemAttendeeInvitingBinding) :
    RecyclerView.ViewHolder(binding.root) {

    private var attendeeClickListener: AttendeesAdapter.IAttendeeClickListener? = null
    private var colorPrimary: Int = 0

    init {
        val typedValue = TypedValue()
        binding.root.context.theme.resolveAttribute(R.attr.colorPrimary, typedValue, true)
        colorPrimary = typedValue.data
    }

    var user: ARoomUser? = null

    fun bindUser(user: ARoomUser) {
        bindName(user)
        bindDepartment(user)
        bindDialing(user)
        setListener()
    }

    fun bindName(user: ARoomUser) {
        setUserName(user.thirdPartyName, user.thirdPartyNameStartPos, user.thirdPartyNameEndPos)
        setUserAlias(user.thirdPartyAlias, user.thirdPartyAliasStartPos, user.thirdPartyAliasEndPos)
    }

    private fun setUserAlias(alias: String?, startPos: Int, endPos: Int) {
        if (startPos != endPos) {
            val spannableString = SpannableString(alias)
            spannableString.setSpan(
                ForegroundColorSpan(colorPrimary),
                startPos,
                endPos,
                Spanned.SPAN_INCLUSIVE_INCLUSIVE
            )
            binding.tvAlias.text = spannableString
        } else {
            binding.tvAlias.text = alias
        }

    }

    private fun setUserName(name: String?, startPos: Int, endPos: Int) {
        when {
            TextUtils.isEmpty(name) -> {
                binding.tvUserName.text = StringUtils.getString(R.string.avc_participants_unknown)
            }
            startPos != endPos -> {
                val spannableString = SpannableString(name)
                spannableString.setSpan(
                    ForegroundColorSpan(colorPrimary),
                    startPos,
                    endPos,
                    Spanned.SPAN_INCLUSIVE_INCLUSIVE
                )
                binding.tvUserName.text = spannableString
            }
            else -> {
                binding.tvUserName.text = name
            }
        }
    }

    fun bindDepartment(user: ARoomUser) {
        binding.tvDepartment.text = binding.root.context.getString(
            R.string.avc_participants_department,
            user.thirdPartyDepartment
        )
    }

    fun bindDialing(user: ARoomUser) {
        if (user.isDialing) {
            binding.ivDialing.apply {
                setImageDrawable(
                    DialingDrawable(
                        SizeUtils.dp2px(20f),
                        SizeUtils.dp2px(5f),
                        colorPrimary
                    )
                )
                (drawable as DialingDrawable).startAnimator()
            }
        } else {
            (binding.ivDialing.drawable as? DialingDrawable)?.stopAnimator()
            binding.ivDialing.setImageResource(R.drawable.avc_ic_calling)
        }
    }

    private fun setListener() {
        object : AntiShakeClickListener() {
            override fun onAntiShakeClicked(view: View?) {
                user?.let {
                    attendeeClickListener?.onAttendeeClicked(it)
                }
            }
        }.apply {
            binding.ivDialing.setOnClickListener(this)
            binding.root.setOnClickListener(this)
        }
    }

    fun setIAttendeeClickListener(listener: AttendeesAdapter.IAttendeeClickListener?) {
        this.attendeeClickListener = listener
    }

}