package io.agora.avc.app.bugReport

import android.view.View
import io.agora.avc.R
import io.agora.avc.bo.Attachment
import io.agora.avc.databinding.AvcItemBugReportBinding
import java.util.*

class BugReportViewHolder constructor(val binding: AvcItemBugReportBinding) :
    androidx.recyclerview.widget.RecyclerView.ViewHolder(binding.root) {

    private var delClickListener: BugReportAdapter.OnDelClickListener? = null


    fun bindTo(attachment: Attachment) {
        if (attachment.path != null) {
            binding.ivAttachment.setImageResource(R.drawable.avc_ic_bug_report_attachment_audio)
            binding.ivDel.visibility = View.VISIBLE
            binding.info.visibility = View.VISIBLE
        } else {
            binding.ivAttachment.setImageResource(R.drawable.avc_ic_bug_report_attachment_add)
            binding.ivDel.visibility = View.GONE
            binding.info.visibility = View.GONE
        }

        binding.info.text = String.format(Locale.getDefault(), "%ds", (attachment.opts.duration / 1000))

        binding.ivDel.setOnClickListener {
            delClickListener?.onDelClicked(attachment)
        }
    }

    fun setOnDelClickListener(listener: BugReportAdapter.OnDelClickListener?) {
        this.delClickListener = listener
    }

}