package io.agora.avc.app.bugReport

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ArrayAdapter
import android.widget.Filter
import android.widget.TextView
import io.agora.avc.bo.valoran.ARoomUser
import io.agora.avc.extensions.getConferenceNicknameMaybeAssistant

class OppositeUserAdapter(
    context: Context,
    private val resource: Int,
    private val textViewResourceId: Int,
) : ArrayAdapter<ARoomUser?>(context, resource, textViewResourceId) {
    private var tempItems = arrayListOf<ARoomUser>()

    private val suggestions: MutableList<ARoomUser> by lazy {
        ArrayList()
    }

    override fun getView(position: Int, convertView: View?, parent: ViewGroup): View {
        var view = convertView
        if (convertView == null) {
            val inflater =
                context.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
            view = inflater.inflate(resource, parent, false)
        }
        val user = getItem(position)
        user?.apply {
            (view?.findViewById<View>(textViewResourceId) as TextView)?.apply {
                text = user.getConferenceNicknameMaybeAssistant()
            }
        }
        return view!!
    }

    override fun getFilter(): Filter {
        return nameFilter
    }

    fun setData(data: ArrayList<ARoomUser>) {
        this.tempItems = data
        clear()
        addAll(data)
    }

    /**
     * Custom Filter implementation for custom suggestions we provide.
     */
    private var nameFilter: Filter = object : Filter() {
        override fun convertResultToString(resultValue: Any): CharSequence {
            return (resultValue as ARoomUser?)?.getConferenceNicknameMaybeAssistant() ?: ""
        }

        override fun performFiltering(constraint: CharSequence?): FilterResults {
            return if (constraint != null) {
                val target = constraint.toString().toLowerCase()
                suggestions.clear()
                for (user in tempItems) {
                    if (user.name?.toLowerCase()?.contains(target) == true) {
                        suggestions.add(user)
                    }
                }
                val filterResults = FilterResults()
                filterResults.values = suggestions
                filterResults.count = suggestions.size
                filterResults
            } else {
                FilterResults()
            }
        }

        override fun publishResults(constraint: CharSequence?, results: FilterResults?) {
            val filterList = results?.values as ArrayList<ARoomUser>?
            if (results != null && results.count > 0) {
                clear()
                filterList?.forEach { user ->
                    add(user)
                }
            }
        }
    }
}