package io.agora.avc.app.calling

import android.content.pm.ActivityInfo
import android.os.Bundle
import android.view.View
import androidx.navigation.fragment.findNavController
import com.agora.valoran.bean.IncomingData
import com.bumptech.glide.Glide
import com.bumptech.glide.load.resource.bitmap.CenterCrop
import io.agora.avc.R
import io.agora.avc.app.master.MainViewModel
import io.agora.avc.databinding.AvcFragmentIncomingBinding
import io.agora.avc.extensions.setNavBarVisibility
import io.agora.avc.glide.BlurTransformation
import io.agora.avc.utils.BarUtils
import io.agora.avc.utils.GsonUtils
import io.agora.frame.base.NovelFragment
import io.agora.logger.Logger

class IncomingFragment : NovelFragment<IncomingViewModel, AvcFragmentIncomingBinding>() {

    private var incomingCall: IncomingData? = null

    private val mainViewModel: MainViewModel by lazy {
        getViewModel(requireActivity().viewModelStore, MainViewModel::class.java)
    }

    override fun getLayoutId(): Int {
        return R.layout.avc_fragment_incoming
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        activity?.requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_PORTRAIT
        activity?.setNavBarVisibility(false)
    }

    override fun allocObserver() {
        mViewModel?.answerCallback?.observe(this) { room ->
            val navController = findNavController()
            if (navController.currentDestination?.id == R.id.incoming) {
                navController.navigateUp()
            }
            if (room != null) {
                mainViewModel.changeRoom(room)
            }
        }
    }

    override fun initialize(savedInstanceState: Bundle?) {
        val data = arguments?.getString(KEY_DATA)
        Logger.i(TAG, "show incoming call:$data")
        incomingCall = GsonUtils.fromJson(data, IncomingData::class.java)
        mBinding.tvName.text = incomingCall?.inviterName
        mBinding.tvContent.text = getString(R.string.avc_invite_in_avc, "", "\n${incomingCall?.rid}")
        Glide.with(this)
            .load(incomingCall?.inviterAvatar)
            .transform(CenterCrop(), BlurTransformation(context))
            .placeholder(R.color.avc_black_800)
            .into(mBinding.ivBg)

        Glide.with(this)
            .load(incomingCall?.inviterAvatar)
            .centerCrop()
            .placeholder(R.drawable.avc_ic_head_portrait2)
            .into(mBinding.ivPhoto)
        mBinding.btnCancel.setOnClickListener {
            val call = incomingCall ?: return@setOnClickListener
            mViewModel?.rejectIncomingCall(call)
        }
        mBinding.btnConfirm.setOnClickListener {
            val call = incomingCall ?: return@setOnClickListener
            mViewModel?.answerIncomingCall(call)
        }
    }

    override fun onBackPressed() {
        incomingCall?.let {
            mViewModel?.rejectIncomingCall(it)
        }
        super.onBackPressed()
    }

    override fun onDestroyView() {
        super.onDestroyView()
    }

    companion object {
        private const val TAG = "[UI][Incoming]"
        const val KEY_DATA = "data"
    }

}