package io.agora.avc.app.calling

import android.app.Application
import com.agora.valoran.bean.IncomingData
import io.agora.avc.R
import io.agora.avc.base.AppViewModel
import io.agora.avc.biz.AppController
import io.agora.avc.biz.event.AppEvent
import io.agora.avc.biz.event.MessageEvent
import io.agora.avc.bo.Room
import io.agora.avc.bo.RoomMode
import io.agora.avc.config.PREFIX_INTERNAL_MEETING
import io.agora.avc.manager.media.MediaPlayer
import io.agora.avc.manager.notice.NotifyResult
import io.agora.frame.base.livedata.EventLiveData
import io.agora.logger.Logger
import javax.inject.Inject

class IncomingViewModel @Inject constructor(
    application: Application,
    appController: AppController,
    private val mediaPlayer:MediaPlayer,
) : AppViewModel(application, appController) {

    val answerCallback = EventLiveData<Room?>()

    private var currentSeq = -1
    private var incomingData: IncomingData? = null

    override fun onCreate() {
        super.onCreate()
    }

    override fun onEventReceived(arg: MessageEvent) {
        when (arg.type) {
            AppEvent.INCOMING_REJECT_EVENT.ordinal -> {
                answerCallback.postValue(null)
            }
            AppEvent.INCOMING_ANSWER_EVENT.ordinal -> {
                handleAnswerResult(arg)
            }
        }
    }

    private fun handleAnswerResult(arg: MessageEvent) {
        val data = arg.obj
        if (data !is NotifyResult) {
            return
        }
        if (data.seq != currentSeq) {
            Logger.w(TAG, "received an old return result")
            return
        }
        if (!data.success) {
            answerCallback.postValue(null)
            return
        }
        val incomingCall = incomingData
        if (incomingCall?.rid == null) {
            Logger.e(TAG, "please check rid, which is empty")
            answerCallback.postValue(null)
            return
        }
        val mode = if (incomingCall.rid.startsWith(PREFIX_INTERNAL_MEETING)) {
            RoomMode.AGORA.value
        } else {
            RoomMode.NORMAL.value
        }
        answerCallback.postValue(Room(incomingCall.rid, incomingCall.pwd, mode))
    }

    fun rejectIncomingCall(incomingCall: IncomingData) {
        currentSeq = appController.getOperationSeqId()
        this.incomingData = incomingCall
        appController.answerIncoming(
            currentSeq,
            pickUp = false,
            fromCallKit = false,
            params = incomingCall
        )
    }

    fun answerIncomingCall(incomingCall: IncomingData) {
        currentSeq = appController.getOperationSeqId()
        this.incomingData = incomingCall
        appController.answerIncoming(
            currentSeq,
            pickUp = true,
            fromCallKit = false,
            params = incomingCall
        )
    }

    override fun getUIEvents(): Array<AppEvent>? {
        return arrayOf(
            AppEvent.INCOMING_REJECT_EVENT,
            AppEvent.INCOMING_ANSWER_EVENT,
        )
    }

    companion object {
        private const val TAG = "[VM][Incoming]"
    }
}