package io.agora.avc.app.chat

import io.agora.avc.R
import io.agora.avc.bo.Message
import io.agora.avc.databinding.AvcItemChatLeftBinding
import io.agora.avc.utils.SpanUtils
import io.agora.avc.utils.TimeUtils

class ChatLeftViewHolder constructor(val binding: AvcItemChatLeftBinding) :
    androidx.recyclerview.widget.RecyclerView.ViewHolder(binding.root) {

    fun bindTo(message: Message?) {
        val spanUtils = SpanUtils()
            .append(getUserName(message))
            .setBold()
            .append("\n")
            .append(message?.textContent ?: "")
        binding.tvContent.text = spanUtils.create()
        message?.timestamp?.let {
            binding.tvTime.text = TimeUtils.getChatTime(it)
        }
    }

    private fun getUserName(message: Message?): String {
        message?.senderName?.let {
            if (it.isNotEmpty()) {
                return it
            }
        }
        return binding.tvContent.context.getString(R.string.avc_unknown_user)
    }
}