package io.agora.avc.app.chat

import android.view.View
import com.agora.valoran.Constants
import io.agora.avc.bo.Message
import io.agora.avc.databinding.AvcItemChatRightBinding
import io.agora.avc.utils.TimeUtils
import io.agora.logger.Logger

class ChatRightViewHolder constructor(val binding: AvcItemChatRightBinding) :
    androidx.recyclerview.widget.RecyclerView.ViewHolder(binding.root) {

    private var onItemListener: ChatAdapter.OnItemListener? = null

    fun bindTo(message: Message?) {
        binding.tvContent.text = message?.textContent
        updateStatus(message)
        message?.timestamp?.let {
            binding.tvTime.text = TimeUtils.getChatTime(it)
        }
        binding.constraintLayout.setOnClickListener {
            message?.let {
                if (it.status == Constants.ChatMessageStatus.getValue(Constants.ChatMessageStatus.FAILURE)) {
                    val messageId = it.messageId
                    if (messageId == null) {
                        Logger.e(TAG, "message id is empty, can not resend")
                        return@setOnClickListener
                    }
                    this.onItemListener?.onClicked(messageId)
                }
            }
        }
    }

    private fun updateStatus(message: Message?) {
        message?.status?.let {
            when (it) {
                Constants.ChatMessageStatus.getValue(Constants.ChatMessageStatus.OK) -> {
                    binding.ivState.visibility = View.INVISIBLE
                }
                Constants.ChatMessageStatus.getValue(Constants.ChatMessageStatus.SENDING) -> {
                    binding.ivState.visibility = View.VISIBLE
                    binding.ivState.loading = true
                }
                Constants.ChatMessageStatus.getValue(Constants.ChatMessageStatus.FAILURE) -> {
                    binding.ivState.visibility = View.VISIBLE
                    binding.ivState.opened = true
                }
            }
        }
    }

    fun setItemClickListener(listener: ChatAdapter.OnItemListener?) {
        this.onItemListener = listener
    }

    companion object {
        private const val TAG = "[UI][ChatRightViewHolder]"
    }
}