package io.agora.avc.app.developer

import android.os.Bundle
import android.view.View
import androidx.navigation.fragment.NavHostFragment
import io.agora.avc.R
import io.agora.avc.bo.DevConfig
import io.agora.avc.databinding.AvcFragmentDeveloperBinding
import io.agora.avc.extensions.safeNavigate
import io.agora.avc.listener.EnvironmentClickedListener
import io.agora.avc.manager.splite.SPLiteProxy
import io.agora.avc.utils.ToastUtils
import io.agora.frame.base.NovelFragment

class DeveloperFragment : NovelFragment<DeveloperViewModel, AvcFragmentDeveloperBinding>() {

    private var isTestServer = true

    private var developerOptions: DeveloperOptions? = null

    private var devconfig: DevConfig? = null

    override fun getLayoutId(): Int {
        return R.layout.avc_fragment_developer
    }

    override fun allocObserver() {
        mViewModel?.modelChangedEvent?.observe(this) { data ->
            this.developerOptions = data
            initView()
        }
        mViewModel?.devConfigChangedEvent?.observe(this) { data ->
            this.devconfig = data
            initView()
        }
        mViewModel?.environmentChanged?.observe(this) {
            this.isTestServer = it
            initView()
        }
    }

    override fun initialize(savedInstanceState: Bundle?) {
        mBinding.actionBar.getTitleView().setOnClickListener(object : EnvironmentClickedListener() {
            override fun onEnvironmentClicked(view: View?) {
                mViewModel?.changeAppEnvironment()
            }
        })

        mBinding.actionBar.getBackIconView().setOnClickListener {
            NavHostFragment.findNavController(this).navigateUp()
        }

        mBinding.showLog.setOnClickListener {
            safeNavigate(R.id.action_developer_to_log)
        }

        mBinding.connRtm.callback = {
            mViewModel?.changeRtmConnected(it)
        }

        mBinding.notUseMeta.callback = {
            mViewModel?.changeUseMeta(it)
        }

        mBinding.notUseDataChannel.callback = {
            mViewModel?.changeUseDataChannel(it)
        }

        mBinding.weWork.callback = {
            if (!SPLiteProxy.isTestServer()) {
                ToastUtils.showShort(getString(R.string.avc_test_function_tips))
            } else {
                mViewModel?.loginWeWork(it)
            }
        }

        mBinding.roomSecure.callback = {
            mViewModel?.changeRoomSecure(it)
        }

        mBinding.lastMileTest.callback = {
            mViewModel?.changeLastMileTest(it)
        }

        mBinding.showMediaDetail.callback = {
            mViewModel?.setVideoDataVisible(it)
        }

        mBinding.videoRate.callback = {
            mViewModel?.setVideoRateVisible(it)
        }

        mBinding.qualityReport.callback = {
            mViewModel?.setQualityReportVisible(it)
        }

        mBinding.mediaBackground.callback = {
            mViewModel?.changeMediaBackground(it)
        }

        mBinding.wifiAP.callback = {
            mViewModel?.changeWifiAP(it)
        }

        mBinding.networkEvaluation.callback = {
            mViewModel?.openNetworkEvaluation(it)
        }

        mBinding.testCrash.callback = {
            mViewModel?.testJavaCrash()
        }
    }

    private fun initView() {
        if (isTestServer) {
            mBinding.actionBar.setTitle(getString(R.string.avc_developer_menu) + getString(R.string.avc_developer_environment_test))
        } else {
            mBinding.actionBar.setTitle(getString(R.string.avc_developer_menu))
        }

        developerOptions?.useRTM?.let {
            mBinding.connRtm.setSwitchChecked(!it)
        }

        developerOptions?.useMeta?.let {
            mBinding.notUseMeta.setSwitchChecked(!it)
        }

        developerOptions?.useDataChannel?.let {
            mBinding.notUseDataChannel.setSwitchChecked(!it)
        }

        developerOptions?.weWorkLogin?.let {
            mBinding.weWork.setSwitchChecked(it)
        }

        developerOptions?.roomSecurity?.let {
            mBinding.roomSecure.setSwitchChecked(it)
        }

        developerOptions?.useLastMile?.let {
            mBinding.lastMileTest.setSwitchChecked(!it)
        }

        developerOptions?.showVideoData?.let {
            mBinding.showMediaDetail.setSwitchChecked(it)
        }

        developerOptions?.videoRate?.let {
            mBinding.videoRate.setSwitchChecked(it)
        }

        developerOptions?.qualityReport?.let {
            mBinding.qualityReport.setSwitchChecked(it)
        }

        developerOptions?.changeVideoBG?.let {
            mBinding.mediaBackground.setSwitchChecked(it)
        }

        developerOptions?.networkEvaluation?.let {
            mBinding.networkEvaluation.setSwitchChecked(it)
        }

        devconfig?.wifiAp?.let {
            mBinding.wifiAP.setSwitchChecked(it)
        }
    }

    companion object {
        private const val TAG = "[UI][Developer]"
    }
}
