package io.agora.avc.app.group

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.app.address.AddressBookNode
import io.agora.avc.app.address.ErrorViewHolder
import io.agora.avc.databinding.AvcItemErrorViewBinding
import io.agora.avc.databinding.AvcItemGroupTailoredMemberBinding
import io.agora.frame.base.BaseRecyclerAdapter

class GroupTailoredAdapter(private val onRefreshClicked: () -> Unit) :
    BaseRecyclerAdapter<AddressBookNode, RecyclerView.ViewHolder>() {
    override fun convert(
        holder: RecyclerView.ViewHolder,
        items: MutableList<AddressBookNode>?,
        position: Int
    ) {
        when (holder) {
            is ErrorViewHolder -> {
                holder.binding.btnConfirm.setOnClickListener {
                    onRefreshClicked.invoke()
                }
            }
            is GroupTailoredViewHolder -> {
                holder.onBind(items?.get(position)) {
                    items?.let {
                        it.removeAt(holder.adapterPosition)
                        notifyItemRemoved(holder.adapterPosition)
                    }
                }
            }
        }
    }

    override fun bindViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            R.layout.avc_item_error_view -> {
                ErrorViewHolder(
                    AvcItemErrorViewBinding.inflate(
                        LayoutInflater.from(parent.context),
                        parent,
                        false
                    )
                )
            }
            else -> {
                GroupTailoredViewHolder(
                    AvcItemGroupTailoredMemberBinding.inflate(
                        LayoutInflater.from(parent.context),
                        parent,
                        false
                    )
                )
            }
        }
    }

    override fun getItemViewType(position: Int): Int {
        return data[position].viewType
    }
}