package io.agora.avc.app.log

import android.app.Application
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import io.agora.frame.base.BaseViewModel
import io.agora.frame.base.livedata.StatusEvent
import io.agora.logger.LogData
import io.agora.logger.Logger
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.schedulers.Schedulers
import javax.inject.Inject

class LogViewModel @Inject constructor(application: Application) : BaseViewModel(application) {
    val logLiveData: MutableLiveData<List<LogData>> = MutableLiveData()

    fun queryLog(type: Int, useLoading: Boolean = true): LiveData<List<LogData>> {
        Observable
            .create<List<LogData>> {
                var log = Logger.getLogList()?.filter { data -> data.type and type != 0 }
                if (log == null) {
                    log = arrayListOf()
                }
                it.onNext(log)
            }
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(object : io.reactivex.Observer<List<LogData>> {
                override fun onComplete() {

                }

                override fun onSubscribe(d: Disposable) {
                    if (useLoading) {
                        statusEvent.postValue(StatusEvent.Status.LOADING)
                    }
                }

                override fun onNext(t: List<LogData>) {
                    statusEvent.postValue(StatusEvent.Status.SUCCESS)
                    logLiveData.value = t
                }

                override fun onError(e: Throwable) {
                    statusEvent.postValue(StatusEvent.Status.ERROR)
                    logLiveData.value = null
                }
            })
        return logLiveData
    }

}