package io.agora.avc.app.master

import android.os.Bundle
import android.view.View
import io.agora.avc.R
import io.agora.avc.databinding.AvcFragmentWeWorkSelectionBinding
import io.agora.avc.widget.COMPANY_AGORA
import io.agora.avc.widget.COMPANY_EASEMOB
import io.agora.frame.base.BaseSheetDialogFragment
import io.agora.frame.base.BaseViewModel

class WeWorkSelectionFragment :
    BaseSheetDialogFragment<BaseViewModel, AvcFragmentWeWorkSelectionBinding>() {

    private val mainViewModel: MainViewModel by lazy {
        getViewModel(requireActivity().viewModelStore, MainViewModel::class.java)
    }

    override fun getLayoutId(): Int {
        return R.layout.avc_fragment_we_work_selection
    }

    override fun allocObserver() {

    }

    override fun onStart() {
        super.onStart()
        mDialog.setCanceledOnTouchOutside(true)
        onConfigurationChanged(resources.configuration)
    }

    override fun initialize(savedInstanceState: Bundle?) {
        mBinding.touchOutside.setOnClickListener {
            onBackPressed()
        }

        mBinding.choose0.setOnClickListener {
            mainViewModel.loginViaWeWork(COMPANY_AGORA)
            onBackPressed()
        }

        mBinding.choose1.setOnClickListener {
            mainViewModel.loginViaWeWork(COMPANY_EASEMOB)
            onBackPressed()
        }
    }

    companion object {
        private const val TAG = "[UI][WeWorkSelection]"
    }

}