package io.agora.avc.app.meeting

import android.content.Context
import android.content.res.Configuration
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.constraintlayout.widget.ConstraintLayout.LayoutParams.*
import androidx.core.view.doOnLayout
import androidx.core.view.updateLayoutParams
import androidx.core.view.updateMargins
import com.google.android.material.bottomsheet.BottomSheetBehavior
import io.agora.avc.databinding.AvcFragmentMeetingBinding
import io.agora.avc.utils.ConvertUtils
import io.agora.avc.utils.ScreenUtils
import io.agora.logger.Logger

class MeetingConfigChangedHelper(
    var context: Context?
) {

    lateinit var binding: AvcFragmentMeetingBinding

    private val smallStreamBehavior by lazy {
        BottomSheetBehavior.from(binding.llSmallStream)
    }

    fun bind(binding: AvcFragmentMeetingBinding, isScreenPortrait: Boolean) {
        this.binding = binding
        adjustUI(isScreenPortrait)
    }

    private fun adjustUI(isScreenPortrait: Boolean) {
        Logger.i(TAG, "adjust ui")

        binding.bottomBar.recreate(isScreenPortrait)
        adjustSmallStream()
        binding.flContainer.scaleToOrigin()
    }

    private fun adjustSmallStream() {
        Logger.i(TAG, "adjust small stream")
        if (binding.rvMediaList.adapter != null) {
            binding.rvMediaList.adapter = binding.rvMediaList.adapter
        }

        if (ScreenUtils.isLandscape()) {
            binding.callLayout.doOnLayout {
                val slideOffset = when (smallStreamBehavior.state) {
                    BottomSheetBehavior.STATE_HALF_EXPANDED -> {
                        smallStreamBehavior.halfExpandedRatio
                    }
                    BottomSheetBehavior.STATE_EXPANDED -> {
                        1f
                    }
                    else -> {
                        0f
                    }
                }

                translationTitleIfNeed(slideOffset)
            }
        }
    }

    fun translationTitleIfNeed(slideOffset: Float) {
        if (ScreenUtils.isLandscape()) {
            binding.llTitle.translationX = (ConvertUtils.dp2px(166f) * slideOffset)
            binding.statusPop.translationX = (ConvertUtils.dp2px(166f) * slideOffset)
        }
    }

    fun onConfigurationChanged(newConfig: Configuration) {
        adjustUI(newConfig.orientation == Configuration.ORIENTATION_PORTRAIT)

        if (newConfig.orientation == Configuration.ORIENTATION_PORTRAIT) {
            binding.llTitle.translationX = 0f
            binding.statusPop.updateLayoutParams<ConstraintLayout.LayoutParams> {
                startToEnd = binding.insetLeftView.id
                matchConstraintPercentWidth = 0.58f
                startToStart = UNSET
            }
            binding.statusPop.translationX = 0f
            binding.mediaStatics.updateLayoutParams<ConstraintLayout.LayoutParams> {
                startToEnd = binding.insetLeftView.id
                endToStart = UNSET
            }
            binding.notificationPop.updateLayoutParams<ConstraintLayout.LayoutParams> {
                updateMargins(top = ConvertUtils.dp2px(18f))
                bottomToBottom = PARENT_ID
                bottomToTop = UNSET
                matchConstraintPercentHeight = 0.5f
            }
            binding.clMainScreenInfo.updateLayoutParams<ConstraintLayout.LayoutParams> {
                updateMargins(bottom = ConvertUtils.dp2px(57f))
                bottomToBottom = binding.cdlSmallStream.id
                bottomToTop = UNSET
                goneBottomMargin = ConvertUtils.dp2px(28f)
            }
            binding.cdlSmallStream.updateLayoutParams<ConstraintLayout.LayoutParams> {
                width = MATCH_PARENT
                bottomToTop = binding.bottomBar.id
                endToEnd = PARENT_ID
                startToStart = PARENT_ID
                startToEnd = UNSET
                topToTop = UNSET
                bottomToBottom = UNSET
            }
            binding.cdlSmallStream.apply {
                rotation = 0f
                translationX = 0f
                translationY = 0f
            }

            binding.bottomBar.updateLayoutParams<ConstraintLayout.LayoutParams> {
                width = MATCH_CONSTRAINT
                updateMargins(bottom = 0)
            }
        } else {
            binding.statusPop.updateLayoutParams<ConstraintLayout.LayoutParams> {
                startToEnd = UNSET
                matchConstraintPercentWidth = 0.33f
                startToStart = binding.llTitle.id
            }
            binding.mediaStatics.updateLayoutParams<ConstraintLayout.LayoutParams> {
                startToEnd = UNSET
                endToStart = binding.insetRightView.id
            }
            binding.notificationPop.updateLayoutParams<ConstraintLayout.LayoutParams> {
                updateMargins(top = ConvertUtils.dp2px(6f))
                bottomToBottom = UNSET
                bottomToTop = binding.bottomBar.id
                topToBottom = binding.llTitle.id
            }
            binding.clMainScreenInfo.updateLayoutParams<ConstraintLayout.LayoutParams> {
                updateMargins(bottom = ConvertUtils.dp2px(6f))
                bottomToBottom = UNSET
                bottomToTop = binding.bottomBar.id
                goneBottomMargin = 0
            }
            binding.cdlSmallStream.updateLayoutParams<ConstraintLayout.LayoutParams> {
                width = binding.callLayout.width
                bottomToTop = UNSET
                startToStart = UNSET
                startToEnd = binding.insetLeftView.id
                endToEnd = binding.insetLeftView.id
                topToTop = PARENT_ID
                bottomToBottom = PARENT_ID
            }
            binding.cdlSmallStream.apply {
                rotation = 90f
                if (binding.cdlSmallStream.height == 0) {
                    ConvertUtils.dp2px(259f)
                } else {
                    binding.cdlSmallStream.height
                }.let {
                    translationX = it / 2f
                }
                translationY = 0f
            }

            binding.bottomBar.updateLayoutParams<ConstraintLayout.LayoutParams> {
                width = WRAP_CONTENT
                updateMargins(bottom = ConvertUtils.dp2px(8f))
            }
        }
        //Correct the audio mode position
//        (binding.callLayout.viewDragHelperCallback as? AudioModeViewDragHelper)
//            ?.onConfigurationChanged(isInAudioMode)
    }

    fun onDestroy() {
        context = null
    }

    companion object {
        private const val TAG = "[UI][MeetingConfigChangedHelper]"
    }
}