package io.agora.avc.app.rating.call

import android.app.Application
import io.agora.avc.R
import io.agora.avc.base.AppViewModel
import io.agora.avc.biz.AppController
import io.agora.avc.biz.event.AppEvent
import io.agora.avc.biz.event.MessageEvent
import io.agora.avc.bo.MosScore
import io.agora.avc.manager.rating.call.*
import io.agora.avc.utils.GsonUtils
import io.agora.frame.base.livedata.EventLiveData
import io.agora.logger.Logger
import javax.inject.Inject

class CallRatingViewModel @Inject constructor(
    application: Application,
    appController: AppController,
    private val callRatingManager: CallRatingManager,
) : AppViewModel(application, appController) {

    val chipDataEvent = EventLiveData<List<Pair<Int, Int>>>()

    var mosScore: MosScore? = null

    override fun onCreate() {
        super.onCreate()
        queryChipData()
    }

    private fun queryChipData() {
        chipDataEvent.postValue(createChipList())
    }

    fun submit(rating: Float, checkedTags: MutableList<Int>, description: String) {
        val mosScoreParam = mosScore
        if (mosScoreParam == null) {
            Logger.e(TAG, "mos score is empty, can not submit")
            return
        }
        val score = rating.toInt()
        val userScore = UserScore(score, checkedTags, description)

        val audioScore = AudioScore(
            userList = mosScoreParam.remote,
            description = description,
            rid = mosScoreParam.rid,
            localScore = mosScoreParam.local.second,
            selectedUid = null,
            localUid = mosScoreParam.local.first.streamId,
            rating = score,
            tags = checkedTags
        )
        val videoScore = VideoScore(
            score = score,
            bName = description,
            rid = mosScoreParam.rid,
            tags = checkedTags,
            mos = mosScoreParam.videoMos,
            sid = mosScoreParam.callId,
            uid = mosScoreParam.local.first.streamId,
        )
        callRatingManager.scoringCall(CallScore(audioScore, videoScore, userScore))
    }

    private fun createChipList(): List<Pair<Int, Int>> {
        return listOf(
            Pair(2, R.string.avc_rate_label_one_b),
            Pair(1, R.string.avc_rate_label_one_a),
            Pair(3, R.string.avc_rate_label_one_c),
            Pair(4, R.string.avc_rate_label_one_e),
            Pair(5, R.string.avc_rate_label_one_d),
            Pair(6, R.string.avc_rate_label_one_f),
            Pair(7, R.string.avc_rate_label_one_g)
        )
    }

    fun setMosScore(data: String) {
        mosScore = GsonUtils.fromJson(data, MosScore::class.java)
    }

    companion object {
        private const val TAG = "[VM][CallScoring]"
    }
}