package io.agora.avc.app.web

import android.net.Uri
import android.os.Bundle
import android.view.View
import android.webkit.CookieManager
import android.webkit.WebView
import androidx.navigation.fragment.findNavController
import io.agora.avc.R
import io.agora.avc.databinding.AvcFragmentWebBinding
import io.agora.frame.base.NovelFragment
import io.agora.logger.Logger

const val KEY_URL = "key_url"

class WebFragment : NovelFragment<WebViewModel, AvcFragmentWebBinding>() {

    private var url: String? = null

    override fun getLayoutId() = R.layout.avc_fragment_web

    override fun initialize(savedInstanceState: Bundle?) {
        this.url = arguments?.getString(KEY_URL)

        Logger.d(TAG, "web url:$url")

        mBinding.webView.setOnShouldOverrideUrlListener(object :
            AgoraWebView.OnShouldOverrideUrlListener {
            override fun onShouldOverrideUrl(uri: Uri?): Boolean {
                Logger.i(TAG, "on should override url:$uri")
                mViewModel?.handleCallback(uri)
                return true
            }
        })
        mBinding.webView.setOnPageFinishedListener(object : AgoraWebView.OnPageFinishedListener {
            override fun onPageFinished(view: WebView?, url: String?) {
                Logger.i(TAG, "page:$url load finish")
                mBinding?.actionBar?.setTitle(view?.title ?: "")
            }
        })
        mBinding.webView.setOnWebChromeClientListener(object :
            AgoraWebView.OnWebChromeClientListener {
            override fun onProgressChanged(view: WebView?, newProgress: Int) {
                mBinding?.progressBar?.progress = newProgress
                if (newProgress == 100) {
                    mBinding?.progressBar?.visibility = View.GONE
                } else {
                    mBinding?.progressBar?.visibility = View.VISIBLE
                }
            }
        })

        removeAllCookies()

        this.url?.let {
            mBinding.webView.loadUrl(it)
        }

        mBinding.webView.requestFocus()
    }

    private fun removeAllCookies() {
        CookieManager.getInstance().removeAllCookies {
            Logger.d(TAG, "remove cookies ${if (it) "success" else "failed"}")
        }
    }

    override fun onDestroyView() {
        mBinding.webView.destroy()
        super.onDestroyView()
    }

    companion object {
        private const val TAG = "[UI][Web]"
    }
}