package io.agora.avc.app.welcome

import android.content.res.Configuration
import android.os.Bundle
import android.view.ViewGroup
import androidx.navigation.Navigation
import io.agora.avc.R
import io.agora.avc.databinding.AvcFragmentWelcomeBinding
import io.agora.frame.base.NovelFragment

class WelcomeFragment : NovelFragment<WelcomeViewModel, AvcFragmentWelcomeBinding>() {

    override fun getLayoutId(): Int {
        return R.layout.avc_fragment_welcome
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        val viewGroup = view as ViewGroup
        viewGroup.removeAllViews()
        val welcome = onCreateView(layoutInflater, viewGroup, null)
        viewGroup.addView(welcome)
    }

    override fun initialize(savedInstanceState: Bundle?) {
        mBinding.start.setOnClickListener {
            Navigation.findNavController(it).popBackStack()
            Navigation.findNavController(it).navigate(R.id.enter)
        }
    }
}
