package io.agora.avc.auth.signin

import android.app.Activity
import android.content.Context
import io.agora.avc.bo.UserSource
import io.agora.avc.utils.DeviceUtils

interface SignInManager {

    fun initialize(context: Context)

    fun signInGoogle(activity: Activity)

    fun signInWework(type: Int)

    fun signOut()

    fun signInByTester()

    fun signOutByTester()

    fun verifyAccount(session: String?, source: Int)

    fun queryAccountInfo(
        code: String,
        source: Int = UserSource.AGORAN.value,
        platform: String = DeviceUtils.getPlatform(),
        deviceName: String = DeviceUtils.getModel()
    )

    fun isAppSupportGoogle(): Boolean
    fun isAppSupportWeiXin(): Boolean
    fun isAppSupportWework(): Boolean

    fun deInitialize()
}