package io.agora.avc.base

import android.app.Application
import io.agora.avc.MyApplication
import io.agora.avc.biz.AppController
import io.agora.avc.biz.event.AppEvent
import io.agora.avc.biz.event.EventObserver
import io.agora.avc.bo.LocalUser
import io.agora.avc.bo.Room
import io.agora.avc.biz.event.MessageEvent
import io.agora.frame.base.BaseViewModel
import java.util.*

abstract class AppViewModel constructor(
    application: Application,
    val appController: AppController
) : BaseViewModel(application) {

    private val eventObserver: EventObserver by lazy {
        object : EventObserver {
            override fun update(o: Observable?, arg: MessageEvent) {
                onEventReceived(arg)
            }
        }
    }

    override fun onCreate() {
        super.onCreate()
        appController.registerObserver(eventObserver, getUIEvents())
    }

    open fun getUIEvents(): Array<AppEvent>? {
        return null
    }

    open fun onEventReceived(arg: MessageEvent) {

    }

    fun getLocalUser(): LocalUser? {
        return getApplication<MyApplication>().appContainer.localUser
    }

    fun getRoom(): Room? {
        return getApplication<MyApplication>().appContainer.room
    }

    override fun onCleared() {
        super.onCleared()
        appController.unregisterObserver(eventObserver, getUIEvents())
    }

}