package io.agora.avc.biz

import android.content.Context
import android.telephony.PhoneStateListener
import android.telephony.TelephonyManager
import io.agora.avc.MyApplication
import io.agora.avc.bo.LocalUser
import io.agora.avc.utils.TelephonyWatcher
import io.agora.logger.Logger

class AVCTelephonyWatcher(val context: Context) : TelephonyWatcher() {

    private var currentPhoneState = TelephonyManager.CALL_STATE_IDLE

    private var lastPhoneState = TelephonyManager.CALL_STATE_IDLE

    private var temporaryMuteAudio = false

    private var temporaryMuteVideo = false

    private fun getLocalUser(): LocalUser? {
        if (context is MyApplication) {
            return context.appContainer.localUser
        }
        return null
    }

    private fun getAppController(): AppController? {
        if (context is MyApplication) {
            return context.appContainer.appController
        }
        return null
    }

    private val phoneStateListener: PhoneStateListener = object : PhoneStateListener() {
        override fun onCallStateChanged(state: Int, phoneNumber: String?) {
            super.onCallStateChanged(state, phoneNumber)
            Logger.i(TAG, "telephone state changed,new state:$state")
            currentPhoneState = state
            if (lastPhoneState == TelephonyManager.CALL_STATE_IDLE
                && currentPhoneState != TelephonyManager.CALL_STATE_IDLE
            ) {
                onActive()
            } else if (lastPhoneState != TelephonyManager.CALL_STATE_IDLE
                && currentPhoneState == TelephonyManager.CALL_STATE_IDLE
            ) {
                onIdle()
            }
            lastPhoneState = currentPhoneState
        }

        private fun onActive() {
            val appController = getAppController()
            appController?.setTemporaryLeave(true)
            val localUser = getLocalUser()
            if (localUser?.isMediaOn()?.not() == true) {
                return
            }
            if (localUser?.audioState == true) {
                temporaryMuteAudio = true
                appController?.setLocalAudio(false)
            }
            if (localUser?.videoState == true) {
                temporaryMuteVideo = true
                appController?.setLocalVideo(false)
            }
        }

        private fun onIdle() {
            val appController = getAppController()
            appController?.setTemporaryLeave(false)
            if (!temporaryMuteAudio && !temporaryMuteVideo) {
                return
            }
            if (temporaryMuteAudio) {
                temporaryMuteAudio = false
                Logger.i(TAG, "When the call ends, restore the audio state")
                appController?.setLocalAudio(true)
            }
            if (temporaryMuteVideo) {
                temporaryMuteVideo = false
                Logger.i(TAG, "When the call ends, restore the video state")
                appController?.setLocalVideo(true)
            }
        }
    }

    fun startWatch() {
        Logger.i(TAG, "register telephone state watcher")
        super.startWatch(phoneStateListener)
    }

    override fun stopWatch() {
        super.stopWatch()
        Logger.i(TAG, "unregister telephone state watcher")
    }

    companion object {
        private const val TAG = "[Comm][Telephone]"
    }
}