package io.agora.avc.biz.vlr

import android.content.Context
import android.view.TextureView
import android.view.View
import com.agora.valoran.Constants
import com.agora.valoran.IValoranEvents
import com.agora.valoran.bean.IncomingData
import com.agora.valoran.bean.SimpleRoomUser
import com.agora.valoran.bean.UserJoinInfo

interface IVlrClient {

    fun initialize(
        context: Context,
        eventObserver: IValoranEvents,
        isEnvProduction: Boolean,
        logPath: String,
        customType: Int
    )

    /*** User Action***/
    fun configUser(streamId: Int, uid: String?, access_token: String?)
    fun configClientInfo(
        uuid: String,
        lang: Int,
        feature: Long,
        appVer: String,
        deviceInfo: String,
        osVersion: String
    )

    fun joinRoom(rid: String?, pwd: String?, info: UserJoinInfo?)
    fun createRoom(rid: String?, pwd: String?, info: UserJoinInfo?)
    fun leaveRoom()
    fun setLocalAudio(on: Boolean)
    fun setLocalVideo(on: Boolean)
    fun startRenderVideo(target: Int, view: View?, mode: Int)
    fun stopRenderVideo(target: Int)
    fun setResolution(resolution: Int)
    fun setMajorUser(target: Int)
    fun disableLocalAudio()
    fun enableLocalAudio()

    /*** Remote Control***/
    fun setRemoteAudio(target: Int, on: Boolean)
    fun setRemoteVideo(target: Int, on: Boolean)
    fun kickRemote(target: Int)
    fun acceptRemoteRequest(type: Int, tag: String?)
    fun refuseRemoteRequest(type: Int, tag: String?)
    fun setMediaProxy(ips: Array<String>, domain: String)

    /*** Room Control***/
    fun applyHost()
    fun giveUpHost()
    fun setRoomAudio(on: Boolean)
    fun setRoomVideo(on: Boolean)
    fun applyScreenShare(seq: Int, hasWatermark: Boolean)
    fun cancelScreenShare()
    fun sendChat(msg: String?)
    fun resendChat(id: Int)
    fun setTemporaryLeave(leave: Boolean)
    fun startCloudRecording()
    fun stopCloudRecording()
    fun startIssueDumping(type: Int, path: String)
    fun stopIssueDumping(type: Int)
    fun applyAssistant(type: Int)
    fun cancelAssistant()
    fun enableAssist(listenOriginSound: Boolean)
    fun disableAssist()
    fun getAddressBook(seq: Int, departmentId: String)
    fun searchAddressBook(seq: Int, content: String)
    fun inviteContacts(seq: Int, sources: ArrayList<SimpleRoomUser>)
    fun answerIncoming(
        seq: Int,
        pickUp: Boolean,
        fromCallKit: Boolean,
        params: IncomingData?
    )

    fun setRoomAudioMuteAll(on: Boolean)
    fun applyUnMuteLocalAudio()

    /*** group ***/
    fun createMeetup(seq: Int, name: String, memberIds: ArrayList<String>)
    fun deleteMeetup(seq: Int, id: String)
    fun updateMeetup(
        seq: Int,
        id: String,
        name: String,
        newIds: ArrayList<String>?,
        deleteIds: ArrayList<String>?
    )

    fun getMeetupList(seq: Int, page: Int, pageSize: Int)
    fun getMeetupDetail(seq: Int, id: String)

    /*** Others ***/
    fun configAudioEffects(effects: List<android.util.Pair<Constants.EffectType, String>>)
    fun adjustPlaybackSignalVolume(volume: Int)
    fun setParameters(type: Int, params: String?)
    fun switchCamera()
    fun getCallId(): String?
    fun createTextureView(context: Context): TextureView
    fun changeToAudioMode()
    fun changeToVideoMode()
    fun biRecord(type: Int, successFlag: Int, code: Int, elapse: Int, param: String)
    fun setBackgroundColor(streamId: Int, color: Int)
    fun startDumpVideoReceiveTrack(uid: Int, dumpFile: String)
    fun stopDumpVideoReceiveTrack()
    fun tryNetworkPromptAction()
    fun closeNetworkPrompt()
    fun destroy()

    fun setEnableSpeakerphone(enable: Boolean)
}