package io.agora.avc.biz.vlr

import android.content.Context
import android.util.Pair
import android.view.TextureView
import android.view.View
import androidx.core.graphics.blue
import androidx.core.graphics.green
import androidx.core.graphics.red
import com.agora.valoran.Constants
import com.agora.valoran.IValoranEvents
import com.agora.valoran.ValoranEngine
import com.agora.valoran.bean.IncomingData
import com.agora.valoran.bean.SimpleRoomUser
import com.agora.valoran.bean.UserJoinInfo
import io.agora.logger.Logger
import javax.inject.Inject

class VlrClientImp @Inject constructor() : IVlrClient {

    private var vlrEngine: ValoranEngine? = null

    override fun initialize(
        context: Context,
        eventObserver: IValoranEvents,
        isEnvProduction: Boolean,
        logPath: String,
        customType: Int
    ) {
        Logger.i(
            TAG,
            "execute initialize, isEnvProduction:$isEnvProduction, logPath:$logPath, customType:$customType"
        )
        vlrEngine =
            ValoranEngine.create(context, eventObserver, isEnvProduction, logPath, customType)
    }

    /*** User Action***/
    override fun configUser(streamId: Int, uid: String?, access_token: String?) {
        vlrEngine?.configUser(streamId, uid, access_token)
    }

    override fun configClientInfo(
        uuid: String,
        lang: Int,
        feature: Long,
        appVer: String,
        deviceInfo: String,
        osVersion: String
    ) {
        vlrEngine?.configClientInfo(uuid, lang, feature, appVer, deviceInfo, osVersion)
    }

    override fun joinRoom(rid: String?, pwd: String?, info: UserJoinInfo?) {
        vlrEngine?.joinRoom(rid, pwd, info)
    }

    override fun createRoom(rid: String?, pwd: String?, info: UserJoinInfo?) {
        vlrEngine?.createRoom(rid, pwd, info)
    }

    override fun leaveRoom() {
        vlrEngine?.leaveRoom()
    }

    override fun setLocalAudio(on: Boolean) {
        vlrEngine?.setLocalAudio(on)
    }

    override fun setLocalVideo(on: Boolean) {
        vlrEngine?.setLocalVideo(on)
    }

    override fun startRenderVideo(target: Int, view: View?, mode: Int) {
        vlrEngine?.startRenderVideo(target, view, mode)
    }

    override fun stopRenderVideo(target: Int) {
        vlrEngine?.stopRenderVideo(target)
    }

    override fun setResolution(resolution: Int) {
        vlrEngine?.setResolution(resolution)
    }

    override fun setMajorUser(target: Int) {
        vlrEngine?.setMajorUser(target)
    }

    override fun disableLocalAudio() {
        vlrEngine?.GetRtcEngine()?.enableLocalAudio(false)
    }

    override fun enableLocalAudio() {
        vlrEngine?.GetRtcEngine()?.enableLocalAudio(true)
    }

    /*** Remote Control***/
    override fun setRemoteAudio(target: Int, on: Boolean) {
        vlrEngine?.setRemoteAudio(target, on)
    }

    override fun setRemoteVideo(target: Int, on: Boolean) {
        vlrEngine?.setRemoteVideo(target, on)
    }

    override fun kickRemote(target: Int) {
        vlrEngine?.kickRemote(target)
    }

    override fun acceptRemoteRequest(type: Int, tag: String?) {
        vlrEngine?.acceptRemoteRequest(type, tag)
    }

    override fun refuseRemoteRequest(type: Int, tag: String?) {
        vlrEngine?.refuseRemoteRequest(type, tag)
    }

    override fun setMediaProxy(ips: Array<String>, domain: String) {
        vlrEngine?.setMediaProxy(ips, domain)
    }

    /*** Room Control***/
    override fun applyHost() {
        vlrEngine?.applyHost()
    }

    override fun giveUpHost() {
        vlrEngine?.giveUpHost()
    }

    override fun setRoomAudio(on: Boolean) {
        vlrEngine?.setRoomAudio(on)
    }

    override fun setRoomVideo(on: Boolean) {
        vlrEngine?.setRoomVideo(on)
    }

    override fun applyScreenShare(seq: Int, hasWatermark: Boolean) {
        vlrEngine?.applyScreenShare(seq, hasWatermark)
    }

    override fun cancelScreenShare() {
        vlrEngine?.cancelScreenShare()
    }

    override fun sendChat(msg: String?) {
        vlrEngine?.sendChat(msg)
    }

    override fun resendChat(id: Int) {
        vlrEngine?.resendChat(id)
    }

    override fun setTemporaryLeave(leave: Boolean) {
        vlrEngine?.setTemporaryLeave(leave)
    }

    override fun startCloudRecording() {
        vlrEngine?.startCloudRecording()
    }

    override fun stopCloudRecording() {
        vlrEngine?.stopCloudRecording()
    }

    override fun startIssueDumping(type: Int, path: String) {
        vlrEngine?.startIssueDumping(type, path)
    }

    override fun stopIssueDumping(type: Int) {
        vlrEngine?.stopIssueDumping(type)
    }

    override fun applyAssistant(type: Int) {
        vlrEngine?.applyAssistant(type)
    }

    override fun cancelAssistant() {
        vlrEngine?.cancelAssistant()
    }

    override fun enableAssist(listenOriginSound: Boolean) {
        vlrEngine?.enableAssist(listenOriginSound)
    }

    override fun disableAssist() {
        vlrEngine?.disableAssist()
    }

    override fun getAddressBook(seq: Int, departmentId: String) {
        vlrEngine?.getAddressBook(seq, departmentId)
    }

    override fun searchAddressBook(seq: Int, content: String) {
        vlrEngine?.searchAddressBook(seq, content.toByteArray())
    }

    override fun inviteContacts(seq: Int, sources: ArrayList<SimpleRoomUser>) {
        val users = arrayOf<SimpleRoomUser>()
        vlrEngine?.inviteContacts(seq, sources.toArray(users))
    }

    override fun answerIncoming(
        seq: Int,
        pickUp: Boolean,
        fromCallKit: Boolean,
        params: IncomingData?
    ) {
        vlrEngine?.answerIncoming(seq, pickUp, fromCallKit, params)
    }

    override fun setRoomAudioMuteAll(on: Boolean) {
        vlrEngine?.setRoomAudioMuteAll(on)
    }

    override fun applyUnMuteLocalAudio() {
        vlrEngine?.applyUnMuteLocalAudio()
    }

    override fun createMeetup(seq: Int, name: String, memberIds: ArrayList<String>) {
        vlrEngine?.createMeetup(seq, name, memberIds)
    }

    override fun deleteMeetup(seq: Int, id: String) {
        vlrEngine?.deleteMeetup(seq, id)
    }

    override fun updateMeetup(
        seq: Int,
        id: String,
        name: String,
        newIds: ArrayList<String>?,
        deleteIds: ArrayList<String>?
    ) {
        vlrEngine?.updateMeetup(seq, id, name, newIds, deleteIds)
    }

    override fun getMeetupList(seq: Int, page: Int, pageSize: Int) {
        vlrEngine?.getMeetupList(seq, page, pageSize)
    }

    override fun getMeetupDetail(seq: Int, id: String) {
        vlrEngine?.getMeetupDetail(seq, id)
    }

    /*** Others ***/
    override fun configAudioEffects(effects: List<Pair<Constants.EffectType, String>>) {
        vlrEngine?.configAudioEffects(effects)
    }

    override fun adjustPlaybackSignalVolume(value: Int) {
        vlrEngine?.GetRtcEngine()?.adjustPlaybackSignalVolume(value)
    }

    override fun setParameters(type: Int, params: String?) {
        vlrEngine?.setParameters(type, params)
    }

    override fun switchCamera() {
        vlrEngine?.switchCamera()
    }

    override fun getCallId(): String? {
        return vlrEngine?.callId
    }

    override fun createTextureView(context: Context): TextureView {
        return ValoranEngine.createTextureView(context)
    }

    override fun changeToAudioMode() {
        vlrEngine?.changeToAudioMode()
    }

    override fun changeToVideoMode() {
        vlrEngine?.changeToVideoMode()
    }

    override fun biRecord(type: Int, successFlag: Int, code: Int, elapse: Int, param: String) {
        vlrEngine?.biRecord(type, successFlag, code, elapse, param)
    }

    override fun setBackgroundColor(streamId: Int, color: Int) {
        val param =
            "{\"che.video.render_background_color\":{\"uid\":$streamId, \"r\":${color.red}, \"g\":${color.green}, \"b\":${color.blue}}}"
        vlrEngine?.GetRtcEngine()?.setParameters(param)
    }

    override fun startDumpVideoReceiveTrack(uid: Int, dumpFile: String) {
        vlrEngine?.GetRtcEngine()?.startDumpVideoReceiveTrack(uid, dumpFile)
    }

    override fun stopDumpVideoReceiveTrack() {
        vlrEngine?.GetRtcEngine()?.stopDumpVideoReceiveTrack()
    }

    override fun tryNetworkPromptAction() {
        vlrEngine?.tryNetworkPromptAction()
    }

    override fun closeNetworkPrompt() {
        vlrEngine?.closeNetworkPrompt()
    }

    override fun destroy() {
        ValoranEngine.destroy()
    }

    override fun setEnableSpeakerphone(enable: Boolean) {
        vlrEngine?.GetRtcEngine()?.setEnableSpeakerphone(enable)
    }

    companion object {
        private const val TAG = "[Comm][VlrClientImp]"
    }
}