package io.agora.avc.bo

/***
 * rtm operate command
 */
enum class AudioDumpStatus(val key: String, val value: Int) {
    UNKNOWN("unknown", 0),
    STARTING("starting", 1),
    STOPPED("stopped", 2),
    ERROR("error", 3),
    COMPLETED("completed", 4);

    companion object {
        fun parse(key: String): Int {
            return valueOf(key).value
        }

        fun parse(num: Int): String {
            for (value in values()) {
                if (value.value == num) {
                    return value.key
                }
            }
            return UNKNOWN.key
        }
    }
}