package io.agora.avc.bo

/**
audio_label枚举：
1 对方说话延时很大 Perceivable delay
2 对方说话很卡 Intermittent voice
3 声音很小 Low sound volume
4 有回声 Noticeable echo
5 有杂音 Noticeable noise
video_label枚举：
1 模糊 Blurriness
2 花屏 Corruption / Mosaic
3 延迟 Lag / Delay
4 卡顿 Frame Freeze
 */
data class ConversationQuality(
    var name: String = "",
    val channelName: String,
    var reportId: String = "",
    var reportStreamId: Int = 0,
    var audioRating: Float = 0f,
    var audioRemark: String = "",
    var videoRating: Float = 0f,
    var videoRemark: String = "",
    var audioLabel: IntArray? = null,
    var videoLabel: IntArray? = null,
    var manual: Boolean = false,
    var callId: String? = null,
    var delta: Long = 0,
    var peerUid: Int = 0
) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ConversationQuality

        if (name != other.name) return false
        if (channelName != other.channelName) return false
        if (reportId != other.reportId) return false
        if (reportStreamId != other.reportStreamId) return false
        if (audioRating != other.audioRating) return false
        if (audioRemark != other.audioRemark) return false
        if (videoRating != other.videoRating) return false
        if (videoRemark != other.videoRemark) return false
        if (audioLabel != null) {
            if (other.audioLabel == null) return false
            if (!audioLabel.contentEquals(other.audioLabel)) return false
        } else if (other.audioLabel != null) return false
        if (videoLabel != null) {
            if (other.videoLabel == null) return false
            if (!videoLabel.contentEquals(other.videoLabel)) return false
        } else if (other.videoLabel != null) return false
        if (manual != other.manual) return false
        if (callId != other.callId) return false
        if (delta != other.delta) return false
        if (peerUid != other.peerUid) return false

        return true
    }

    override fun hashCode(): Int {
        var result = name.hashCode()
        result = 31 * result + channelName.hashCode()
        result = 31 * result + reportId.hashCode()
        result = 31 * result + reportStreamId
        result = 31 * result + audioRating.hashCode()
        result = 31 * result + audioRemark.hashCode()
        result = 31 * result + videoRating.hashCode()
        result = 31 * result + videoRemark.hashCode()
        result = 31 * result + (audioLabel?.contentHashCode() ?: 0)
        result = 31 * result + (videoLabel?.contentHashCode() ?: 0)
        result = 31 * result + manual.hashCode()
        result = 31 * result + (callId?.hashCode() ?: 0)
        result = 31 * result + delta.hashCode()
        result = 31 * result + peerUid
        return result
    }
}