package io.agora.avc.bo

import io.agora.avc.bo.valoran.ARoomUser
import io.agora.avc.manager.bugreport.DumpStatus

data class Issue(
    var issueId: String? = null,
    var name: String? = null,
    var issueName: String,
    var issueStreamId: Int,
    var path: String? = null,
    var status: Int = 0,
    val appVersion: String,
    var description: String? = null,
    var oppositeStreamId: Int? = null,
    var packet: String? = null,
    val rid: String,
    val sdkVersion: String,
    var tags: MutableList<Int>? = null,
    var attachmentList: ArrayList<Attachment>? = null,
    val platform: String,
    var userSnapshot: MutableList<ARoomUser>? = null,
    val createTime: Long,
    @DumpStatus
    var dumpStatus: Int = DumpStatus.NONE
) {
    @Synchronized
    fun addAttachment(attachment: Attachment) {
        if (attachmentList == null) {
            attachmentList = arrayListOf()
        }
        attachmentList?.add(attachment)
    }

    @Synchronized
    fun removeAttachment(attachment: Attachment) {
        attachmentList?.remove(attachment)
    }
}