package io.agora.avc.bo

import android.os.Bundle
import androidx.annotation.IntDef
import io.agora.avc.manager.notice.NoticeType

data class MeetingNotification(
    val code: NoticeCode,
    @NoticeType
    val noticeType: Int,
    @MeetingNotificationType
    val notificationType: Int,
    val group: Array<NoticeCode>? = null,
    val eventType: Int? = null,
    var title: String = "",
    var content: String? = null,
    var contentIsLink: Boolean = false,
    var showTime: Long = 0,
    var show: Boolean = true,
    var data: Bundle? = null,
) {

    companion object {
        /**
         * Display timeout disappears automatically
         * ps: time unit is millisecond
         */
        const val NOTICE_TYPE_C_TIME_OUT = 3000
        const val NOTICE_TYPE_AB_TIME_OUT = Integer.MAX_VALUE

        /**
         * group of code
         */
        const val KEY_GROUP = "key_group"
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MeetingNotification

        if (code != other.code) return false
        if (noticeType != other.noticeType) return false
        if (notificationType != other.notificationType) return false
        if (group != null) {
            if (other.group == null) return false
            if (!group.contentEquals(other.group)) return false
        } else if (other.group != null) return false
        if (eventType != other.eventType) return false
        if (title != other.title) return false
        if (content != other.content) return false
        if (contentIsLink != other.contentIsLink) return false
        if (showTime != other.showTime) return false
        if (show != other.show) return false
        if (data != other.data) return false

        return true
    }

    override fun hashCode(): Int {
        var result = code.hashCode()
        result = 31 * result + noticeType
        result = 31 * result + notificationType
        result = 31 * result + (group?.contentHashCode() ?: 0)
        result = 31 * result + (eventType ?: 0)
        result = 31 * result + title.hashCode()
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + contentIsLink.hashCode()
        result = 31 * result + showTime.hashCode()
        result = 31 * result + show.hashCode()
        result = 31 * result + (data?.hashCode() ?: 0)
        return result
    }
}

@IntDef(
    MeetingNotificationType.NO_1,
    MeetingNotificationType.NO_2,
    MeetingNotificationType.NO_3,
    MeetingNotificationType.NO_4,
    MeetingNotificationType.NO_5,
    MeetingNotificationType.NO_6,
    MeetingNotificationType.NO_7,
    MeetingNotificationType.NO_8,
    MeetingNotificationType.NO_9,
    MeetingNotificationType.CLOUD_RECORDING,
    MeetingNotificationType.DUMP,
    MeetingNotificationType.WIFI_AP
)
@kotlin.annotation.Retention(AnnotationRetention.SOURCE)
annotation class MeetingNotificationType {
    companion object {
        const val NO_1 = 1 //net work quality
        const val NO_2 = 2 //peer request
        const val NO_3 = 3 //screen share
        const val NO_4 = 4 //leave temporarily
        const val NO_5 = 5 //Device connection
        const val NO_6 = 6 //invite camera
        const val NO_7 = 7 //media determine
        const val NO_8 = 8 //room assistant
        const val NO_9 = 9 //invite
        const val DUMP = 100
        const val CLOUD_RECORDING = 101
        const val WIFI_AP = 102
        const val NO_103 = 103//unMute media
    }
}