package io.agora.avc.bo

import io.agora.avc.R

enum class NoticeCode(val stringsId: Int?) {
    NOT_CODE(null),

    CODE_ROOM_ERROR(R.string.avc_room_error),
    CODE_ROOM_RTM_DISCONNECTED(R.string.avc_room_rtm_disconnected),
    CODE_ROOM_RTC_DISCONNECTED(R.string.avc_room_rtc_disconnected),
    CODE_ROOM_RTM_DISCONNECTED_PREVIEW(R.string.avc_room_rtm_disconnected_preview),

    //local event
    CODE_SCREEN_SHARING_ERROR(R.string.avc_screen_sharing_error),
    CODE_INVITE_MICROPHONE_CLOSE(R.string.avc_peer_invite_microphone_close),
    CODE_INVITE_CAMERA_CLOSE(R.string.avc_peer_invite_camera_close),
    CODE_DEFAULT_BOTH(R.string.avc_room_default_both),
    CODE_DEFAULT_CAMERA(R.string.avc_room_default_camera),
    CODE_DEFAULT_MICROPHONE(R.string.avc_room_default_microphone),
    CODE_JOIN_FAIL_WRONG_PASSWORD(R.string.avc_join_fail_wrong_password),
    CODE_JOIN_FAIL_AGORA_LOGIN_PERMISSION(R.string.avc_join_fail_agora_login_permission),
    CODE_JOIN_FAIL_ROOM_NAME_INVALID(R.string.avc_join_fail_room_name_invalid),
    CODE_JOIN_FAIL_SEVER_KICK_OUT(R.string.avc_join_fail_sever_kick_out),
    CODE_ROOM_LEFT_TOAST(R.string.avc_room_left_toast),
    CODE_SCREEN_SHARING_START(R.string.avc_screen_sharing_start),
    CODE_JOIN_FAIL_LINK_EXPIRED(R.string.avc_join_fail_link_expired),
    CODE_SETTING_ACCOUNT_IN_FAILED(R.string.avc_setting_account_in_failed),
    CODE_JOIN_ROOM_LOGIN_EXPIRED(R.string.avc_join_room_login_expired),
    CODE_ROOM_AGORA_INVITE_DISALLOW(R.string.avc_room_agora_invite_disallow),
    CODE_ROOM_AGORA_INVITE_ALLOW(R.string.avc_room_agora_invite_allow),
    CODE_ROOM_ALREADY_IN(R.string.avc_room_already_in),
    CODE_ROOM_INVITE_LINK_FAILED(R.string.avc_room_invite_link_failed),
    CODE_JOIN_CONNECTING_RTM_ERROR(R.string.avc_join_connecting_rtm_error),
    CODE_JOIN_CONNECTING_RTM_NODE_ERROR(R.string.avc_join_connecting_rtm_node_error),
    CODE_JOIN_FAIL_DATA_ABNORMAL(R.string.avc_join_fail_data_abnormal),
    CODE_ROOM_ALREADY_EXISTS(R.string.avc_room_already_exists),
    CODE_ROOM_NOT_EXISTS(R.string.avc_room_not_exists),


    //remote event
    CODE_INVITE_CAMERA_REJECT(R.string.avc_peer_invite_camera_reject),
    CODE_INVITE_MICROPHONE_REJECT(R.string.avc_peer_invite_microphone_reject),
    CODE_PEER_INVITE_CAMERA_RECEIVE_RESPOND(R.string.avc_peer_invite_camera_receive_respond),
    CODE_PEER_INVITE_MICROPHONE_RECEIVE_RESPOND(R.string.avc_peer_invite_microphone_receive_respond),
    CODE_PEER_INVITE_MICROPHONE_RECEIVE(R.string.avc_peer_invite_microphone_receive),
    CODE_PEER_INVITE_CAMERA_RECEIVE(R.string.avc_peer_invite_camera_receive),
    CODE_PEER_UN_MUTE_MEDIA_RECEIVE(R.string.avc_peer_invite_camera_receive),
    CODE_JOIN_ROOM_REMOVE(R.string.avc_join_room_remove),
    CODE_PEER_INVITE_NETWORK_OFF_CAMERA(R.string.avc_peer_invite_network_off_camera),
    CODE_PEER_INVITE_NETWORK_OFF_MICROPHONE(R.string.avc_peer_invite_network_off_microphone),

    CODE_AVC_MUTE_ALL_RAISE_POP(R.string.avc_mute_all_raise_pop),
    CODE_AVC_MUTE_ALL_HOST_NOTIFY(R.string.avc_mute_all_host_notify),
    //todo replace string
    CODE_ALL_UNMUTED(R.string.avc_all_unmuted),
    CODE_AVC_MUTE_ALL_REJECT_NOTIFY(R.string.avc_mute_all_reject_notify),
    CODE_AVC_MUTE_ALL_AGREE_NOTIFY(R.string.avc_mute_all_agree_notify),
    CODE_AVC_MUTE_ALL_NO_RESPOND_NOTIFY(R.string.avc_mute_all_no_respond_notify),

    //operation result
    CODE_INVITE_HOST(R.string.avc_peer_invite_host),
    CODE_SETTING_DEFAULT_ROOM_SETTING_FAIL(R.string.avc_setting_default_room_setting_fail),
    CODE_CLOUD_RECORDING_HOST(R.string.avc_cloud_recording_host),
    CODE_CLOUD_RECORDING_EXIST(R.string.avc_cloud_recording_exist),
    CODE_CLOUD_RECORDING_START_FAIL(R.string.avc_cloud_recording_start_fail),
    CODE_CLOUD_RECORDING_MYSELF(R.string.avc_cloud_recording_myself),
    CODE_CLOUD_RECORDING_END(R.string.avc_cloud_recording_end),
    CODE_CLOUD_RECORDING_END_FAIL(R.string.avc_cloud_recording_end_fail),
    CODE_CLOUD_RECORDING_SHORT(R.string.avc_cloud_recording_short),
    CODE_CLOUD_RECORDING_FILE_FAIL(R.string.avc_cloud_recording_file_fail),

    //warning
    CODE_ROOM_DEVICE_ECHO(R.string.avc_room_device_echo),
    CODE_WIFI_AP(R.string.avc_wifi_ap),

    //screen share
    CODE_SCREEN_SHARING_INTERRUPTED(R.string.avc_screen_sharing_interrupted),
    CODE_SCREEN_SHARING_END(R.string.avc_screen_sharing_end),
    CODE_FRAUD_SCREEN_SHARING(R.string.avc_fraud_screen_sharing),

    //video rating
    CODE_VIDEO_RATING_NO_REMOTE_USER(R.string.avc_video_rating_no_remote_user),

    //network
    CODE_NETWORK_LOCAL_POOR(R.string.avc_network_local_poor),
    CODE_NETWORK_PEER_POOR(R.string.avc_network_peer_poor),
    CODE_NETWORK_LOCAL_DOWN(R.string.avc_network_local_down),
    CODE_NETWORK_PEER_DOWN(R.string.avc_network_peer_down),
    CODE_NETWORK_LOCAL_REMINDER(R.string.avc_network_local_reminder),
    CODE_NETWORK_PEER_REMINDER(R.string.avc_network_peer_reminder),
    CODE_NETWORK_PEER_WAIT(R.string.avc_network_peer_wait),
    CODE_NETWORK_RESOLUTION_REMINDER(R.string.avc_network_resolution_reminder),
    CODE_NETWROK_RESOLUTION_DONE(R.string.avc_netwrok_resolution_done),
    CODE_NETWORK_CAMERA_REMINDER(R.string.avc_network_camera_reminder),
    CODE_NETWORK_CAMERA_DONE(R.string.avc_network_camera_done),

    //room assistant
    CODE_AS_ROOM_APPLY_SUCCESS(R.string.avc_as_room_apply_success),
    CODE_AS_ROOM_APPLY_FAIL(R.string.avc_as_room_apply_fail),
    CODE_AS_SETTING_APPLY_FAIL(R.string.avc_as_setting_apply_fail),
    CODE_AS_ROOM_APPLY_TIME_OUT(R.string.avc_as_room_apply_time_out),
    CODE_AS_ROOM_ASK_HOST_EN(R.string.avc_as_room_ask_host_en),
    CODE_AS_ROOM_ASK_HOST_CN(R.string.avc_as_room_ask_host_cn),
    CODE_AS_ROOM_BACK(R.string.avc_as_room_back),
    CODE_AS_ROOM_LEAVE_OUT(R.string.avc_as_room_leave_out),
    CODE_AS_ROOM_LEAVE_TEMP(R.string.avc_as_room_leave_temp),
    CODE_AS_OPEN_TITLE_EN(R.string.avc_as_open_title_en),
    CODE_AS_OPEN_TITLE_CN(R.string.avc_as_open_title_cn),
    CODE_AS_ROOM_ANSWER_USERS_YES(R.string.avc_as_room_answer_users_yes),
    CODE_AS_ROOM_ANSWER_USERS_NO(R.string.avc_as_room_answer_users_no),

    //app upgrade
    CODE_SETTING_VERSION_LATEST(R.string.avc_setting_version_latest),
    CODE_STRID_UPDATER_ERROR_TITLE(R.string.avc_strid_updater_error_title),
    CODE_UPGRADE_ERROR_FILE_PATH(R.string.avc_upgrade_error_file_path),
    CODE_UPGRADE_DOWNLOADING(R.string.avc_strid_updater_downloading),

    //invite
    CODE_INVITE_ALERT(R.string.avc_invite_alert),
    CODE_INVITE_INVALID(R.string.avc_invite_invalid),
    CODE_INVITE_FEEDBACK(R.string.avc_invite_feedback),
    CODE_GROUP_MEMBER_EXCEED(R.string.avc_group_member_exceed),
    CODE_GROUP_EXCEED(R.string.avc_group_exceed),

    //meetup
    CODE_GROUP_NAME_ERROR(R.string.avc_group_name_error),
}