package io.agora.avc.bo.valoran

/**
 * Used to take over [com.agora.valoran.bean.RoomInfo] objects from valoran.
 *
 * If Valoran modifies the RoomInfo later
 * , the M layer and VM layer can be kept as intact as possible
 * , and only changes in this class are required.
 */
data class RoomInfo(
    var rid: String? = null,
    var pwd: String? = null,
    var audioState: Boolean = false,
    var videoState: Boolean = false,
    var audioMuted: Boolean = false,
    var hostUid: String? = null,
    var hostName: String? = null,
    var hostThirdPartyName: String? = null,
    var hostThirdPartyAlias: String? = null,
    var elapsedTime: Long = 0
)

