package io.agora.avc.dao

import androidx.room.Database
import androidx.room.RoomDatabase
import io.agora.avc.po.Attach
import io.agora.avc.po.IncomingRecord
import io.agora.avc.po.Problem

@Database(entities = [Problem::class, Attach::class, IncomingRecord::class], version = 1)
abstract class AppDatabase : RoomDatabase() {
    abstract fun problemDao(): ProblemDao
    abstract fun attachDao(): AttachDao
    abstract fun incomingRecordDao(): IncomingRecordDao

    companion object {
        const val DB_NAME = "avc_db"
    }
}
