package io.agora.avc.dao

import android.Manifest
import io.agora.avc.MyApplication
import io.agora.avc.R

object PermissionDao {

    fun getDeniedDetails(permissionsDenied: MutableList<String>?): String {
        val resources = MyApplication.appContext.resources

        val builder = StringBuilder()
        if (permissionsDenied != null) {
            for (i in permissionsDenied.indices) {
                if (i != 0) {
                    builder.append(",")
                }

                when (permissionsDenied[i]) {
                    Manifest.permission.RECORD_AUDIO -> {
                        builder.append(resources.getString(R.string.avc_permission_audio))
                    }
                    Manifest.permission.CAMERA -> {
                        builder.append(resources.getString(R.string.avc_permission_camera))
                    }
                    Manifest.permission.READ_EXTERNAL_STORAGE -> {
                        builder.append(resources.getString(R.string.avc_permission_storage))
                    }
                }
            }
        }

        return builder.toString()
    }

    fun isAllGranted(
        permissionsGranted: MutableList<String>?,
        permissionRequest: Array<String>
    ): Boolean {
        for (request in permissionRequest) {
            if (permissionsGranted?.contains(request) == false) {
                return false
            }
        }
        return true
    }

}