package io.agora.avc.dao

import androidx.room.*
import io.agora.avc.po.Problem
import io.agora.avc.po.ProblemWithAttach

@Dao
interface ProblemDao {
    @Insert
    fun insertAll(vararg problem: Problem)

    @Insert
    fun insert(problem: Problem): Long

    @Delete
    fun delete(problem: Problem)

    @Update
    fun update(problem: Problem)

    @Transaction
    @Query("SELECT * FROM problem WHERE id = :id")
    fun getProblemWithAttach(id: Long): ProblemWithAttach

    @Transaction
    @Query("SELECT * FROM problem")
    fun getAll(): List<ProblemWithAttach>
}