package io.agora.avc.di.module

import dagger.Module
import dagger.android.ContributesAndroidInjector
import io.agora.avc.app.address.*
import io.agora.avc.app.attendees.AttendeesFragment
import io.agora.avc.app.audio.AudioFragment
import io.agora.avc.app.bugReport.BugReportFragment
import io.agora.avc.app.calling.IncomingFragment
import io.agora.avc.app.chat.ChatFragment
import io.agora.avc.app.chat.ChatInputFragment
import io.agora.avc.app.developer.DeveloperFragment
import io.agora.avc.app.enter.EnterFragment
import io.agora.avc.app.group.GroupTailoredFragment
import io.agora.avc.app.group.NameEditFragment
import io.agora.avc.app.log.LogFragment
import io.agora.avc.app.master.WeWorkSelectionFragment
import io.agora.avc.app.meeting.MeetingFragment
import io.agora.avc.app.mine.LoginOperationFragment
import io.agora.avc.app.mine.MineFragment
import io.agora.avc.app.operation.OperationFragment
import io.agora.avc.app.rating.audio.AudioRatingFragment
import io.agora.avc.app.rating.call.CallRatingFragment
import io.agora.avc.app.setting.RoomSettingsFragment
import io.agora.avc.app.splash.SplashFragment
import io.agora.avc.app.web.WeworkWebFragment
import io.agora.avc.app.web.WebFragment
import io.agora.avc.app.welcome.WelcomeFragment
import io.agora.avc.widget.bottomsheet.BottomSheetFragment
import io.agora.frame.di.component.BaseFragmentSubcomponent

@Module(subcomponents = [BaseFragmentSubcomponent::class])
abstract class FragmentModule {
    @ContributesAndroidInjector
    abstract fun contributeSplashFragment(): SplashFragment?

    @ContributesAndroidInjector
    abstract fun contributeEnterFragment(): EnterFragment?

    @ContributesAndroidInjector
    abstract fun contributeWelcomeFragment(): WelcomeFragment?

    @ContributesAndroidInjector
    abstract fun contributeMeetingFragment(): MeetingFragment?

    @ContributesAndroidInjector
    abstract fun contributeAttendeesFragment(): AttendeesFragment?

    @ContributesAndroidInjector
    abstract fun contributeChatFragment(): ChatFragment?

    @ContributesAndroidInjector
    abstract fun contributeRoomSettingsFragment(): RoomSettingsFragment?

    @ContributesAndroidInjector
    abstract fun contributeDeveloperFragment(): DeveloperFragment?

    @ContributesAndroidInjector
    abstract fun contributeMineFragment(): MineFragment?

    @ContributesAndroidInjector
    abstract fun contributeLogFragment(): LogFragment?

    @ContributesAndroidInjector
    abstract fun contributeAudioFragment(): AudioFragment?

    @ContributesAndroidInjector
    abstract fun contributeWeworkWebFragment(): WeworkWebFragment?

    @ContributesAndroidInjector
    abstract fun contributeBugReportFragment(): BugReportFragment?

    @ContributesAndroidInjector
    abstract fun contributeChatInputFragment(): ChatInputFragment?

    @ContributesAndroidInjector
    abstract fun contributeOperationFragment(): OperationFragment?

    @ContributesAndroidInjector
    abstract fun contributeAudioRatingFragment(): AudioRatingFragment?

    @ContributesAndroidInjector
    abstract fun contributeWeWorkSelectionFragment(): WeWorkSelectionFragment?

    @ContributesAndroidInjector
    abstract fun contributeCallRatingFragment(): CallRatingFragment?

    @ContributesAndroidInjector
    abstract fun contributeIncomingFragment(): IncomingFragment?

    @ContributesAndroidInjector
    abstract fun contributeAddressBookFragment(): AddressBookFragment?

    @ContributesAndroidInjector
    abstract fun contributeAddressBookSearchFragment(): AddressBookSearchFragment?

    @ContributesAndroidInjector
    abstract fun contributeGroupTailoredFragment(): GroupTailoredFragment?

    @ContributesAndroidInjector
    abstract fun contributeNameEditFragment(): NameEditFragment?

    @ContributesAndroidInjector
    abstract fun contributeGroupOperationFragment(): GroupOperationFragment?

    @ContributesAndroidInjector
    abstract fun contributeAddressBookContainerFragment(): AddressBookContainerFragment?

    @ContributesAndroidInjector
    abstract fun contributeMemberSelectedFragment(): MemberSelectedFragment?

    @ContributesAndroidInjector
    abstract fun contributeLoginOperationFragment(): LoginOperationFragment?

    @ContributesAndroidInjector
    abstract fun contributeWebFragment(): WebFragment?

    @ContributesAndroidInjector
    abstract fun contributeBottomSheetFragment(): BottomSheetFragment?
}