package io.agora.avc.di.module

import dagger.Module
import dagger.android.ContributesAndroidInjector
import io.agora.avc.push.fcm.FcmService
import io.agora.avc.push.hms.HuaweiMessageService
import io.agora.avc.push.xiaomi.MiPushMessageService
import io.agora.avc.service.DaemonService
import io.agora.avc.service.RequestService
import io.agora.frame.di.component.BaseServiceSubcomponent

@Module(subcomponents = [BaseServiceSubcomponent::class])
abstract class ServiceModule {

    @ContributesAndroidInjector
    abstract fun contributeDaemonService(): DaemonService?

    @ContributesAndroidInjector
    abstract fun contributeRequestService(): RequestService?

    @ContributesAndroidInjector
    abstract fun contributeFcmService(): FcmService?

    @ContributesAndroidInjector
    abstract fun contributeHuaweiMessageService(): HuaweiMessageService?

    @ContributesAndroidInjector
    abstract fun contributeMiPushMessageService(): MiPushMessageService?
}