package io.agora.avc.di.module

import androidx.lifecycle.ViewModel
import dagger.Binds
import dagger.Module
import dagger.multibindings.IntoMap
import io.agora.avc.app.address.AddressBookContainerViewModel
import io.agora.avc.app.address.AddressBookViewModel
import io.agora.avc.app.address.GroupOperationViewModel
import io.agora.avc.app.address.MemberSelectedViewModel
import io.agora.avc.app.attendees.AttendeesViewModel
import io.agora.avc.app.audio.AudioViewModel
import io.agora.avc.app.bugReport.BugReportViewModel
import io.agora.avc.app.calling.IncomingViewModel
import io.agora.avc.app.chat.ChatViewModel
import io.agora.avc.app.developer.DeveloperViewModel
import io.agora.avc.app.enter.EnterViewModel
import io.agora.avc.app.group.GroupTailoredViewModel
import io.agora.avc.app.group.NameEditViewModel
import io.agora.avc.app.log.LogViewModel
import io.agora.avc.app.master.MainViewModel
import io.agora.avc.app.meeting.MeetingViewModel
import io.agora.avc.app.mine.MineViewModel
import io.agora.avc.app.operation.OperationViewModel
import io.agora.avc.app.rating.audio.AudioRatingViewModel
import io.agora.avc.app.rating.call.CallRatingViewModel
import io.agora.avc.app.setting.RoomSettingsViewModel
import io.agora.avc.app.splash.SplashViewModel
import io.agora.avc.app.web.WebViewModel
import io.agora.avc.app.welcome.WelcomeViewModel
import io.agora.avc.widget.bottomsheet.BottomSheetViewModel
import io.agora.frame.di.scope.ViewModelKey

@Module
abstract class ViewModelModule {
    @Binds
    @IntoMap
    @ViewModelKey(SplashViewModel::class)
    abstract fun bindSplashViewModel(viewModel: SplashViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(WelcomeViewModel::class)
    abstract fun bindWelcomeViewModel(viewModel: WelcomeViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(WebViewModel::class)
    abstract fun bindWebViewModel(viewModel: WebViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(MainViewModel::class)
    abstract fun bindMainViewModel(viewModel: MainViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(EnterViewModel::class)
    abstract fun bindEnterViewModel(viewModel: EnterViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(AttendeesViewModel::class)
    abstract fun bindAttendeesViewModel(viewModel: AttendeesViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(ChatViewModel::class)
    abstract fun bindChatViewModel(viewModel: ChatViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(MeetingViewModel::class)
    abstract fun bindMeetingViewModel(viewModel: MeetingViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(MineViewModel::class)
    abstract fun bindMineViewModel(viewModel: MineViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(RoomSettingsViewModel::class)
    abstract fun bindRoomSettingsViewModel(viewModel: RoomSettingsViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(LogViewModel::class)
    abstract fun bindLogViewModel(viewModel: LogViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(DeveloperViewModel::class)
    abstract fun bindDeveloperViewModel(viewModel: DeveloperViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(AudioViewModel::class)
    abstract fun bindAudioViewModel(viewModel: AudioViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(BugReportViewModel::class)
    abstract fun bindBugReportViewModel(viewModel: BugReportViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(OperationViewModel::class)
    abstract fun bindOperationViewModel(viewModel: OperationViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(AudioRatingViewModel::class)
    abstract fun bindAudioRatingViewModel(viewModel: AudioRatingViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(CallRatingViewModel::class)
    abstract fun bindCallRatingViewModel(viewModel: CallRatingViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(IncomingViewModel::class)
    abstract fun bindIncomingViewModel(viewModel: IncomingViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(AddressBookViewModel::class)
    abstract fun bindAddressBookViewModel(viewModel: AddressBookViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(AddressBookContainerViewModel::class)
    abstract fun bindAddressBookContainerViewModel(viewModel: AddressBookContainerViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(GroupTailoredViewModel::class)
    abstract fun bindGroupTailoredViewModel(viewModel: GroupTailoredViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(NameEditViewModel::class)
    abstract fun bindNameEditViewModel(viewModel: NameEditViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(GroupOperationViewModel::class)
    abstract fun bindGroupOperationViewModel(viewModel: GroupOperationViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(MemberSelectedViewModel::class)
    abstract fun bindMemberSelectedViewModel(viewModel: MemberSelectedViewModel?): ViewModel?

    @Binds
    @IntoMap
    @ViewModelKey(BottomSheetViewModel::class)
    abstract fun bindBottomSheetViewModel(viewModel: BottomSheetViewModel?): ViewModel?
}