package io.agora.avc.extensions

import com.agora.valoran.bean.RoomUser
import com.agora.valoran.bean.SimpleRoomUser
import io.agora.avc.MyApplication
import io.agora.avc.R
import io.agora.avc.bo.LocalUser
import io.agora.avc.bo.Room
import io.agora.avc.bo.VideoStats
import io.agora.avc.bo.valoran.ARoomUser
import io.agora.avc.utils.StringUtils
import java.util.concurrent.CopyOnWriteArrayList

fun RoomUser.toARoomUser(): ARoomUser {
    return ARoomUser().also {
        it.update(this)
    }
}

fun SimpleRoomUser.toARoomUser(): ARoomUser {
    return ARoomUser().also {
        it.updateBy(this)
    }
}

fun Array<SimpleRoomUser>.toARoomUserList(): List<ARoomUser> {
    val aRoomUserList = arrayListOf<ARoomUser>()
    this.forEach {
        aRoomUserList.add(it.toARoomUser())
    }
    return aRoomUserList
}

fun Array<RoomUser>.toARoomUserList(): List<ARoomUser> {
    val aRoomUserList = arrayListOf<ARoomUser>()
    this.forEach {
        aRoomUserList.add(it.toARoomUser())
    }
    return aRoomUserList
}

fun ARoomUser.update(that: RoomUser) {
    this.streamId = that.streamId
    this.name = that.name

    // Biz User Info=that.streamId,
    this.uid = that.uid
    this.isHost = that.isHost
    this.isInterrupt = that.isInterrupt
    this.isCloudRecording = that.isCloudRecording
    this.issueDumpState = that.issueDumpState
    this.feature = that.feature
    this.portraitId = that.portraitId
    this.avatar = that.avatar
    this.isThirdPartyLoggedIn = that.isThirdPartyLoggedIn
    this.thirdPartyName = that.thirdPartyName
    this.thirdPartyUid  = that.thirdPartyUid
    this.thirdPartyAlias = that.thirdPartyAlias
    this.thirdPartyDepartment = that.thirdPartyDepartment
    this.inviteBy = that.inviteBy
    this.isAssistant = that.isAssistant
    this.online = that.online
    this.isAttendee = that.isAttendee
    this.isDialing = that.isDialing

    // Media User Info=that.streamId,
    this.audioState = that.audioState
    this.isAudioPending = that.isAudioPending
    this.isVideoPending = that.isVideoPending
    this.videoState = that.videoState
    this.isSpeaking = that.isSpeaking
    this.quality = that.quality
    this.shareId = that.shareId
    this.parentStreamId = that.parentStreamId
    this.hasWatermark = that.hasWatermark

    //stats
    this.volume = that.volume
    this.width = that.width
    this.height = that.height
    this.fps = that.fps
    this.bitrate = that.bitrate
    this.streamType = that.streamType
    this.rotation = that.rotation
}

fun ARoomUser.updateBy(that: SimpleRoomUser) {
    this.streamId = that.streamId
    this.name = that.name

    // Biz User Info=that.streamId,
    this.uid = that.uid
    this.thirdPartyName = that.thirdPartyName
    this.thirdPartyAlias = that.thirdPartyAlias
}

fun ARoomUser.isMySelf() = this is LocalUser

fun ARoomUser.isMyShareScreen(localUser: LocalUser): Boolean {
    return (parentStreamId != 0 && parentStreamId == localUser.streamId)
            || (streamId != 0 && streamId == localUser.shareId)
}

fun ARoomUser.isHost(hostId: String?): Boolean {
    return hostId != null && uid == hostId
}

fun ARoomUser.hasControlPermission(hostId: String?) =
    (isHost(hostId) || StringUtils.isEmpty(hostId))

fun ARoomUser.getConferenceNickname(): String {
    val appContext = MyApplication.appContext
    val result = if (!isThirdPartyLoggedIn) {
        name
    } else if (isThirdPartyLoggedIn &&
        appContext is MyApplication &&
        appContext.appContainer.room?.isInternal() == true
    ) {
        getThirdPartyNickName()
    } else {
        name
    }
    if (result == null || result.isEmpty()) {
        return StringUtils.getString(R.string.avc_unknown_user)
    }
    return result
}

fun ARoomUser.getConferenceNicknameMaybeAssistant(): String =
    if (isAssistant) {
        StringUtils.getString(R.string.avc_as_name)
    } else {
        getConferenceNickname()
    }


/**
 * return 'false' if is internal meeting and not login
 */
fun ARoomUser.hasPrivatePermission(room: Room?): Boolean {
    return room?.isInternal() == false || isThirdPartyLoggedIn
}

fun ARoomUser.getThirdPartyNickName(): String? {
    if (!StringUtils.isEmpty(thirdPartyAlias)) {
        return "$thirdPartyName(${thirdPartyAlias})"
    }
    return thirdPartyName
}

fun ARoomUser.getVideoStats(): VideoStats {
    return VideoStats(
        bitrate = bitrate,
        frameRate = fps,
        streamType = streamType,
        width = width,
        height = height,
        rotation = rotation
    )
}

fun ARoomUser.copy(): ARoomUser {
    val user = ARoomUser()
    user.streamId = this.streamId
    user.name = this.name

    // Biz User Info=this.streamId,
    user.uid = this.uid
    user.isHost = this.isHost
    user.isInterrupt = this.isInterrupt
    user.isCloudRecording = this.isCloudRecording
    user.issueDumpState = this.issueDumpState
    user.feature = this.feature
    user.portraitId = this.portraitId
    user.avatar = this.avatar
    user.isThirdPartyLoggedIn = this.isThirdPartyLoggedIn
    user.thirdPartyName = this.thirdPartyName
    user.thirdPartyUid  = this.thirdPartyUid
    user.thirdPartyAlias = this.thirdPartyAlias
    user.thirdPartyDepartment = this.thirdPartyDepartment
    user.inviteBy = this.inviteBy
    user.isAssistant = this.isAssistant
    user.online = this.online
    user.isAttendee = this.isAttendee
    user.isDialing = this.isDialing

    // Media User Info=this.streamId,
    user.audioState = this.audioState
    user.isAudioPending = this.isAudioPending
    user.isVideoPending = this.isVideoPending
    user.videoState = this.videoState
    user.isSpeaking = this.isSpeaking
    user.quality = this.quality
    user.shareId = this.shareId
    user.parentStreamId = this.parentStreamId
    user.hasWatermark = this.hasWatermark

    //stats
    user.volume = this.volume
    user.width = this.width
    user.height = this.height
    user.fps = this.fps
    user.bitrate = this.bitrate
    user.streamType = this.streamType
    user.rotation = this.rotation
    return user
}

fun CopyOnWriteArrayList<ARoomUser>.copy(): List<ARoomUser> {
    val result = arrayListOf<ARoomUser>()
    this.forEach {
        if (it is LocalUser) {
            result.add(it.copy())
        } else {
            result.add(it.copy())
        }
    }
    return result
}