package io.agora.avc.extensions

import android.app.Activity
import android.view.View
import android.widget.PopupWindow
import androidx.annotation.StringRes
import io.agora.avc.utils.StringUtils
import io.agora.avc.widget.TextPopupWindow
import io.agora.avc.widget.TipPopupWindow
import io.agora.avc.widget.MediaVideoPopupWindow

fun showTextPop(
    activity: Activity,
    target: View,
    @StringRes
    stringRes: Int,
    direction: Int = TipPopupWindow.DIRECTION_DOWN,
    dismissListener: PopupWindow.OnDismissListener? = null
) {
    val pos = IntArray(2)
    target.getLocationOnScreen(pos)
    pos[0] += target.width / 2
    pos[1] += target.height
    TextPopupWindow(activity, StringUtils.getString(stringRes)).apply {
        showAtLocation(pos, direction)
        if (dismissListener != null) {
            setOnDismissListener {
                dismissListener.onDismiss()
            }
        }
    }
}

fun showPop(
    target: View,
    direction: Int = TipPopupWindow.DIRECTION_DOWN,
    initPop: (() -> TipPopupWindow)
) {
    val pos = IntArray(2)
    target.getLocationInWindow(pos)
    pos[0] += target.width / 2
    if (direction == TipPopupWindow.DIRECTION_DOWN) {
        pos[1] += target.height
    } else {
        pos[1] -= target.height
    }

    initPop.invoke().apply {
        showAtLocation(pos, direction)
    }

}