package io.agora.avc.manager.bugreport

import io.agora.avc.bo.Issue
import io.agora.avc.bo.IssueNo
import io.reactivex.Observable
import okhttp3.MultipartBody

interface BugReporter {

    /**
     * clean audio dump files by problem id
     */
    fun cleanAudioDumpFiles(problemId: Long)

    /**
     *  Find the corresponding Problem data
     *  from the database according to the problemId
     *  , and then report it to the server
     */
    fun reportIssue(problemId: Long)

    fun reportIssue(issue: Issue)

    /**
     * cancel current reporting issue
     */
    fun cancelReportIssue()

    fun reportProblem(
        appVersion: String,
        description: String?,
        issueName: String,
        issueStreamId: String,
        oppositeStreamId: Int?,
        platform: String,
        rid: String,
        sdkVersion: String,
        tags: IntArray?,
        file: MultipartBody.Part?
    ): Observable<IssueNo>

}