package io.agora.avc.manager.media

import android.app.Application
import android.media.AudioAttributes
import android.os.Build
import io.agora.avc.R
import io.agora.avc.utils.LanguageUtils
import io.agora.logger.Logger
import javax.inject.Inject

class MediaPlayerImpl @Inject constructor(
    private val application: Application,
) : MediaPlayer {

    private var mediaPlayer: android.media.MediaPlayer? = null
    private var currentResId: Int? = null

    override fun playBeKickOut() {
        if (LanguageUtils.isChinese()) {
            playMusic(R.raw.avc_be_removed_cn, false)
        } else {
            playMusic(R.raw.avc_be_removed_en, false)
        }
    }

    override fun playMusic(resId: Int, loop: Boolean) {
        if (mediaPlayer != null) {
            stopMusic()
        }
        this.mediaPlayer =
            android.media.MediaPlayer.create(application.applicationContext, resId).apply {
                val attributes = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    AudioAttributes.Builder()
                        .setUsage(AudioAttributes.USAGE_MEDIA)
                        .setContentType(AudioAttributes.CONTENT_TYPE_SPEECH)
                        .build()
                } else {
                    null
                }
                if (attributes != null && Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    setAudioAttributes(attributes)
                }
                setOnErrorListener { mp, what, extra ->
                    Logger.e(TAG, "media play occur error,type:$what extra:$extra")
                    stopMusic()
                    true
                }
                setOnCompletionListener {
                    if (loop) {
                        start()
                    } else {
                        stopMusic()
                    }
                }
                start()
                currentResId = resId
            }
    }

    override fun stopMusic() {
        this.mediaPlayer?.pause()
        this.mediaPlayer?.stop()
        this.mediaPlayer?.release()
        this.mediaPlayer = null
    }

    override fun isPlaying(resId: Int?) =
        this.mediaPlayer?.isPlaying == true && (resId == null || currentResId == resId)

    companion object {
        private const val TAG = "[Comm][MediaPlayer]"
    }
}