package io.agora.avc.manager.notice

import android.os.Bundle
import androidx.annotation.IntDef
import io.agora.avc.bo.MeetingNotificationType
import io.agora.avc.bo.NoticeCode

data class NoticeEvent(
    val code: NoticeCode,
    @NoticeType
    var type: Int = NoticeType.TOAST,
    @MeetingNotificationType
    var notificationType: Int? = null,
    var obj: Any? = null,
    var data: Bundle? = null,
    var show: Boolean = true
) {
    companion object {
        const val KEY_USER_NAME = "key_user_name"
        const val KEY_INVITER = "key_inviter"
    }
}

@IntDef(
    NoticeType.TOAST,
    NoticeType.NOTIFICATION_A,
    NoticeType.NOTIFICATION_B,
    NoticeType.NOTIFICATION_C,
    NoticeType.DIALOG,
    NoticeType.STATUS
)
@kotlin.annotation.Retention(AnnotationRetention.SOURCE)
annotation class NoticeType {
    companion object {
        const val TOAST = 0

        /**
         * just has a close btn, it will disappear by operation
         */
        const val NOTIFICATION_A = 1

        /**
         * like dialog, has operation button, it will disappear by operation
         */
        const val NOTIFICATION_B = 2

        /**
         * There is no operation button, it will disappear automatically
         */
        const val NOTIFICATION_C = 3
        const val DIALOG = 4
        const val STATUS = 5
    }
}
