package io.agora.avc.manager.quality

import io.agora.avc.bo.ConversationQuality
import io.agora.avc.bo.LocalUser
import io.agora.avc.utils.AppUtils

interface QualityManager {

    fun start()

    fun createConversation(
        channelId: String,
        name: String,
        reportId: String,
        reportStreamId: Int,
        callId: String?,
        peerUid: Int,
        manual: Boolean
    ): ConversationQuality

    fun forbidQualityReport()

    fun notifyUserChanged(localUser: LocalUser)

    fun reportConversationQuality(
        conversationQuality: ConversationQuality,
        appVersionName: String = AppUtils.getAppVersionName()
    )

    /**
     * when user leave the room,auto show quality report dialog
     * if remote user existed & remote user media open &
     * local users enter the room for more than MIN_DETECT_TIME
     */
    fun needQualityReport(): Boolean
}