package io.agora.avc.manager.rating.call

import io.agora.avc.bo.valoran.ARoomUser

data class CallScore(
    val audioScore: AudioScore,
    val videoScore: VideoScore,
    val userScore: UserScore
)

data class AudioScore(
    val userList: List<Pair<ARoomUser, Int>>,
    val description: String? = null,//User with poor experience
    val rid: String,//avc room name
    val localScore: Int,//local comprehensive quality
    val selectedUid: Int? = null,//the uid user selected
    val localUid: Int,//local uid
    val rating: Int?,//user rating
    val tags: MutableList<Int>? = null,//user tag
)

data class VideoScore(
    val score: Int,//user rating
    val bName: String? = null,//User with poor experience
    val rid: String,//avc room name
    val tags: MutableList<Int>? = null,//user tag
    val mos: Int,//local comprehensive quality
    val sid: String,//call id
    val uid: Int,//local uid
)

data class UserScore(
    val score: Int,
    val tags: MutableList<Int>? = null,//user tag
    val description: String?,
)