package io.agora.avc.manager.splite

import io.agora.avc.bo.AppConfig
import io.agora.avc.bo.AppTips
import io.agora.avc.bo.DevConfig
import io.agora.avc.bo.InnerInfo

interface SPLite {
    fun migrate()
    fun getInnerInfo(): InnerInfo?
    fun setInnerInfo(value: InnerInfo?)
    fun getLastVersion(): String
    fun setLastVersion(value: String)
    fun getNotice(): String
    fun setNotice(value: String)
    fun getUserName(): String
    fun setUserName(value: String)
    fun getPortraitId(): String
    fun setPortraitId(value: String)
    fun getAccessToken(): String
    fun getRtmToken(): String
    fun setRtmToken(value: String)
    fun getUserInfo(): String
    fun setUserInfo(value: String)
    fun getAudioSetting(): Boolean
    fun setAudioSetting(value: Boolean)
    fun getVideoSetting(): Boolean
    fun setVideoSetting(value: Boolean)
    fun getDarkTheme(): Int
    fun setDarkTheme(value: Int)
    fun getDevelopMode(): Boolean
    fun setDevelopMode(value: Boolean)
    fun getShowWelcome(): Boolean
    fun setShowWelcome(value: Boolean)
    fun privacyShowed(): Boolean
    fun setShowPrivacy(value: Boolean)
    fun getResolutionOption(): Int
    fun setResolutionOption(value: Int)
    fun getRoomSecure(): Boolean
    fun setRoomSecure(value: Boolean)
    fun getPictureMode(): Boolean
    fun setPictureMode(value: Boolean)
    fun getRtcParameters(): Set<String>
    fun setRtcParameters(value: Set<String>)
    fun isTestServer(): Boolean
    fun setTestServer(value: Boolean)
    fun getRtcMediaCopy(): Boolean
    fun setRtcMediaCopy(value: Boolean)
    fun getAvcGuid(): String
    fun setAvcGuid(value: String)
    fun clear()
    fun clearToken()
    fun getAppTips(): AppTips?
    fun setAppTips(appTips: AppTips?)
    fun clearAppTips()
    fun setRoomMode(mode: Int)
    fun getRoomMode(): Int
    fun saveAppConfig(config: String)
    fun getAppConfig(): AppConfig?
    fun saveDevConfig(config: String)
    fun getDevConfig(): DevConfig?
    fun saveOpenNotificationGuideTime(time: Long)
    fun getOpenNotificationGuideTime(): Long?
    fun getDeviceUUID(): String?
    fun saveDeviceUUID(uuid: String)
    fun saveBannerNotificationGuideTime(time: Long)
    fun getBannerNotificationGuideTime(): Long?

}