package io.agora.avc.manager.upgrade

import io.agora.avc.bo.AppVersion
import io.agora.avc.bo.Latest
import io.agora.avc.net.download.Downloader
import io.agora.frame.http.progress.ProgressListener

interface AppUpgradeManager {

    fun hasNewVersion(appVersion: AppVersion?, localVersion: String, filter: Boolean): Boolean

    fun isForceUpgrade(appVersion: AppVersion?, localVersion: String): Boolean

    fun showNoticeIfNeed(msg: String): Boolean

    fun getUpgradeUrl(latestVersion: Latest): String?

    fun downloadApk(
        url: String,
        version: String,
        forceUpdate: Boolean,
        downloadDelay: Long = 0L,
        progressListener: ProgressListener? = null,
        completeListener: Downloader.CompleteListener? = null,
        errorListener: Downloader.ErrorListener? = null,
    )

    fun forcingUpgrade(): Boolean
}