package io.agora.avc.net.api

import com.google.gson.JsonObject
import io.agora.avc.bo.*
import io.agora.avc.net.bean.BaseNo
import io.reactivex.Observable
import okhttp3.MultipartBody
import okhttp3.RequestBody
import okhttp3.ResponseBody
import retrofit2.http.*

interface ApiService {

    @Streaming
    @GET
    fun downloadApk(@Url url: String): Observable<ResponseBody>

    //Get application version information
    @GET("avcservice/v1/app-update")
    fun getAppVer(
        @Query("platform") platform: String,
        @Query("version") version: String,
        @Query("type") type: Int,
        @Query("lang") lang: String
    ): Observable<AppVersion>

    //Get application configuration information
    @GET("avcservice/v1/app-config")
    fun getAppConfig(
        @Query("platform") platform: String,
        @Query("version") version: String,
        @Query("type") type: Int,
        @Query("view") lang: String
    ): Observable<AppConfig>


    @POST("usrservice/v1/account/getToken")
    fun getToken(@Body tokenReqBody: TokenReqBody): Observable<UserInfo>

    //Get RtmToken
    @GET("avcservice/v1/account/getRtmToken")
    fun getRTMToken(): Observable<RTMToken>

    //Update user information
    @POST("usrservice/v1/account/update")
    fun updateUsrInfo(@Body usrUpdateBody: UserUpdateBody): Observable<BaseNo>

    //Get Rtm ServerId
    @GET("avcservice/v1/rtmnode")
    fun getRTMNode(@Query("rid") rid: String): Observable<RTMNode>

    //Upload user avatar
    @POST("usrservice/v1/account/portrait")
    fun uploadUsrPortrait(@Body body: RequestBody): Observable<UserInfo>


    //report conversation quality
    @POST("usrservice/v1/account/generalReport")
    fun reportQuality(@Body map: HashMap<String, Any>): Observable<BaseNo>

    /**
     * When adjusting the interface path or adding an upload interface,
     * you need to adjust LogInterceptor,
     * @see io.agora.avc.net.interceptor.LogInterceptor
     * otherwise the upload log will become larger
     */
    @Multipart
    @POST("usrservice/v1/account/generalLog")
    fun uploadLog(
        @PartMap partMap: @JvmSuppressWildcards Map<String, RequestBody>,
        @Part file: MultipartBody.Part
    ): Observable<ResponseBody>

    @POST("usrservice/v1/account/login")
    fun queryInnerSession(@Body data: JsonObject): Observable<InnerSession>

    @POST("usrservice/v1/account/logout")
    fun delInnerSession(): Observable<BaseNo>

    @POST("usrservice/v1/account/verifyLogin")
    fun verifySession(): Observable<InnerSession>

    @GET("usrservice/v1/account/linkId")
    fun queryLinkId(@Query("rid") rid: String): Observable<Link>

    @GET("usrservice/v1/account/innerMeetingInfo")
    fun queryInnerMeetingInfo(@Query("linkId") linkId: String): Observable<InnerMeeting>

    @Multipart
    @POST("usrservice/v1/account/generalIssue")
    fun reportIssue(
        @PartMap partMap: @JvmSuppressWildcards Map<String, RequestBody>,
        @Part file: MultipartBody.Part?
    ): Observable<IssueNo>

    @POST("usrservice/v1/account/autoQA")
    fun weWorkAutoLogin(@Body data: JsonObject): Observable<BaseNo>

    @POST("usrservice/v1/account/audioReport")
    fun audioReport(@Body audioReportBody: JsonObject): Observable<BaseNo>

    @POST("usrservice/v1/account/feedback")
    fun reportCallQuality(@Body body: JsonObject): Observable<BaseNo>

    @POST("usrservice/v1/account/device-token")
    fun reportToken(@Body body: JsonObject): Observable<BaseNo>
}
