package io.agora.avc.net.converter

import android.graphics.BitmapFactory
import okhttp3.ResponseBody
import retrofit2.Converter
import java.io.IOException

class BitmapResponseBodyConverter<T> : Converter<ResponseBody, T?> {
    @Throws(IOException::class)
    override fun convert(value: ResponseBody): T? {
        return try {
            BitmapFactory.decodeStream(value.byteStream()) as T
        } catch (e: Exception) {
            null
        }
    }
}