package io.agora.avc.net.converter

import android.graphics.Bitmap
import okhttp3.RequestBody
import okhttp3.ResponseBody
import org.json.JSONObject
import retrofit2.Converter
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.io.InputStream
import java.lang.reflect.Type

class CustomConverter : Converter.Factory() {
    override fun responseBodyConverter(
        type: Type,
        annotations: Array<Annotation>,
        retrofit: Retrofit
    ): Converter<ResponseBody, *>? {
        if (type === JSONObject::class.java) {
            return JsonResponseBodyConverter<JSONObject>()
        }
        if (type === InputStream::class.java) {
            return InputStreamResponseBodyConverter<InputStream>()
        }
        if (type === Bitmap::class.java) {
            return BitmapResponseBodyConverter<Bitmap>()
        }
        return if (type === String::class.java) {
            StringResponseBodyConverter<String>()
        } else GsonConverterFactory.create().responseBodyConverter(type, annotations, retrofit)
    }

    override fun requestBodyConverter(
        type: Type,
        parameterAnnotations: Array<Annotation>,
        methodAnnotations: Array<Annotation>,
        retrofit: Retrofit
    ): Converter<*, RequestBody>? {
        return if (type === JSONObject::class.java) {
            JsonRequestBodyConverter<JSONObject>()
        } else GsonConverterFactory.create().requestBodyConverter(
            type, parameterAnnotations, methodAnnotations,
            retrofit
        )
    }

    companion object {
        fun create(): CustomConverter {
            return CustomConverter()
        }
    }
}