package io.agora.avc.net.converter

import okhttp3.ResponseBody
import retrofit2.Converter
import java.io.IOException

class InputStreamResponseBodyConverter<T> : Converter<ResponseBody, T?> {
    @Throws(IOException::class)
    override fun convert(value: ResponseBody): T? {
        return try {
            value.byteStream() as T
        } catch (e: Exception) {
            null
        }
    }
}