package io.agora.avc.net.converter

import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Converter
import java.io.IOException

class JsonResponseBodyConverter<T> : Converter<ResponseBody, T?> {
    @Throws(IOException::class)
    override fun convert(value: ResponseBody): T? {
        val jsonObj: JSONObject
        return try {
            jsonObj = JSONObject(value.string())
            jsonObj as T
        } catch (e: JSONException) {
            null
        }
    }
}